import React from "react";
import { useState } from "react";
import Overlay from "../../../utils/Overlay";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Success from "../../UI/Success";
import Error from "../../UI/Error";
import { useRef } from "react";
import useOutsideClick from "../../../hooks/useOutsideClick";
import { useEffect } from "react";

const UpdateCancellationCharge = ({
  cancellationCharge,
  value,
  openPopup,
  success,
  setSuccess,
  onBackdropClick,
}) => {


  const hourRef = useRef();

  let cancellationKey =
    value == "payAsuGo"
      ? "pay_as_you_go"
      : value == "member"
        ? "members"
        : "emergency";
  let cancellationHours =
    cancellationCharge?.[cancellationKey]?.data?.cancellation_window?.value;

  let canCancel = cancellationCharge?.[cancellationKey]?.cancellation_allowed;

  const axiosPrivate = useAxiosIntercept();

  let cancellationChargeValue =
    cancellationCharge?.[cancellationKey]?.data?.cancellation_charge;
  const [hoursValue, setHoursValue] = useState(cancellationHours);
  const [chargeValue, setChargeValue] = useState(cancellationChargeValue);
  const [canCancelValue, setCanCancelValue] = useState(canCancel);
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [chargeError, setChargeError] = useState("");
  const [cancellationWindowError, setCancellationWindowError] = useState("");
  const [cancellationBookingHours, setCancellationBookingHours] = useState({
    bookingHours: false,
  });
  useEffect(() => {
    setCanCancelValue(canCancel);
    setChargeValue(cancellationChargeValue);
    setHoursValue(cancellationHours);
  }, [canCancel, cancellationChargeValue, cancellationHours]);
  const handelCancelValue = (e) => {
    setCanCancelValue(e.target.value);
    setCancellationWindowError("");
    setErrorMessage("");
    setChargeError("");
  };

  const handelCharge = (e) => {
    setChargeValue(e.target.value);
    setChargeError("");
  };
  const handelEditHours = (e, id) => {
    setHoursValue(id);
    setCancellationWindowError("");
    setCancellationBookingHours({
      bookingHours: false,
    });
  };
  useOutsideClick(hourRef, (e) => {
    setCancellationBookingHours({
      bookingHours: false,
    });
  });

  //  console.log(cancellationHours);
  // const bookingAllowed = planData[id].package_info[0].maximum_booking_allowed;
  var hours = new Array(12);
  const handeldropDown = (e) => {
    setCancellationBookingHours({
      [e.currentTarget.id]: !cancellationBookingHours[e.currentTarget.id],
    });
  };
  var data;
  const handelClose = () => {
    onBackdropClick();
    //setCanCancelValue("");
    setSuccess(!success);
    setCanCancelValue(canCancel);
    setChargeValue(cancellationChargeValue);
    setHoursValue(cancellationHours);
    setErrorMessage("");
    setChargeError("");
  };

  if (canCancelValue == "1") {
    data = {};
    data = {
      cancellation_allowed: parseInt(canCancelValue),
      data: {
        cancellation_window: {
          unit: "H",
          value: hoursValue,
        },
        cancellation_charge: chargeValue,
      },
    };
  } else {
    data = {};
    data = {
      cancellation_allowed: parseInt(canCancelValue),
    };
  }

  const upDate = async () => {
    let error = false;
    if (canCancelValue == 1) {
      if (chargeValue == "" || chargeValue === undefined) {
        error = true;
        setChargeError("This field is required");
      }
      else if (chargeValue < 0) {
        setChargeError("");
        error = true;
        setChargeError("Value must be greater than 0");
      }

      if (hoursValue == "" || hoursValue === undefined) {
        error = true;
        setCancellationWindowError("Select cancellation window");
      }
    }
    if (!error) {
      if (value === "payAsuGo") {
        var payAsugorequest = {
          config_data: {
            site: "admin",
            module: "settings",
            config_key: "cancellation_charges",
            value: {
              ...cancellationCharge,
              pay_as_you_go: data,
            },
          },
        };
      }

      if (value === "member") {
        var memberRequest = {
          config_data: {
            site: "admin",
            module: "settings",
            config_key: "cancellation_charges",
            value: {
              ...cancellationCharge,
              members: data,
            },
          },
        };
      }
      if (value === "emergency") {
        var emergencyRequest = {
          config_data: {
            site: "admin",
            module: "settings",
            config_key: "cancellation_charges",
            value: {
              ...cancellationCharge,
              emergency: data,
            },
          },
        };
      }

      const upDatePayAsuGoUrl =
        process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
      const response = await axiosPrivate.post(
        upDatePayAsuGoUrl,
        value === "payAsuGo"
          ? payAsugorequest
          : value == "member"
            ? memberRequest
            : emergencyRequest
      );
      if (response?.data?.status === 200) {
        setErrorMessage("");
        setSuccessMessage("");
        setSuccessMessage("Data updated successfully");
        setTimeout(() => {
          onBackdropClick(true);
          setSuccess(!success);
          setCanCancelValue("");
          setChargeValue("");
          setHoursValue("");
          setSuccessMessage("");
          setErrorMessage("");
        }, 3000);
      } else {
        setSuccessMessage("");
        setSuccessMessage("");
        setErrorMessage(response?.data?.message);
      }
    }
  };

  return (
    openPopup && (
      <Overlay>
        <div
          class="model_box_child"
          id="CancellationCharge1"
          style={{ width: "400px" }}
        >
          <div class="ap_heading">
            <h4>
              Manage cancellation
              <span
                class="material-symbols-rounded black close_model"
                onClick={handelClose}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP">
              <div class="promoText customer">
                <h4>{value == "payAsuGo" ? "Pay as you go" : value == "member" ? "Members" : "Emergency"}</h4>
              </div>
              <div class="addTime dForm">
                <div class="fieldGroup mr-0">
                  <em class="smallLabel">Select cancellaton right</em>

                  <ul class="yType">
                    <li>
                      <input
                        type="radio"
                        id="yTypeRadio1"
                        name="yTypeRadioY"
                        checked={canCancelValue == "0" && "checked"}
                        value="0"
                        onChange={(e) => handelCancelValue(e)}
                      />
                      <label for="yTypeRadio1">Cannot cancel</label>
                    </li>
                    <li>
                      <input
                        type="radio"
                        id="yTypeRadio2"
                        name="yTypeRadioY"
                        checked={canCancelValue == "1" && "checked"}
                        value="1"
                        onChange={(e) => handelCancelValue(e)}
                      />
                      <label for="yTypeRadio2">Can cancel</label>
                      {canCancelValue == "1" && (
                        <div class="lists ml-24 mt-16">
                          <div class="xType alignBottom">
                            <div class="fieldGroup mt-0">
                              <em class="smallLabel">Cancellation window</em>
                              <div
                                ref={hourRef}
                                class="multiOption"
                                id="bookingHours"
                                onClick={(e) => handeldropDown(e)}
                              >
                                <div
                                  class={
                                    cancellationBookingHours.bookingHours
                                      ? "selectBox open"
                                      : "selectBox"
                                  }
                                >
                                  <p class="selected">
                                    {hoursValue
                                      ? hoursValue
                                      : cancellationHours ? cancellationHours : "Select"}
                                    <i class="material-symbols-rounded grey">
                                      expand_more
                                    </i>
                                  </p>
                                  <div class="selectDrop customScroll hFix">
                                    <ul class="dropMenu">
                                      {Array.apply(
                                        null,
                                        Array(parseInt(12))
                                      ).map(function (x, i) {
                                        return (
                                          <li
                                            class={
                                              hoursValue === i + 1
                                                ? "selected"
                                                : ""
                                            }
                                          >
                                            <a
                                              href="javascript:void(0);"
                                              id={i + 1}
                                              onClick={(e) =>
                                                handelEditHours(e, i + 1)
                                              }
                                            >
                                              {i + 1}
                                              {hoursValue === i + 1 ? (
                                                <i class="material-symbols-rounded">
                                                  done
                                                </i>
                                              ) : (
                                                ""
                                              )}
                                            </a>
                                          </li>
                                        );
                                      })}
                                    </ul>
                                  </div>
                                </div>
                                <div class="sepText bg">
                                  <span class="active">hours</span>
                                </div>
                              </div>

                            </div>
                            <div class="fieldGroup mt-0 mr-0 fullWidth">
                              <em class="smallLabel">Cancellation charge</em>
                              <div class="multiOption">
                                <input
                                  type="number"
                                  name=""
                                  value={chargeValue}
                                  style={{ width: "70px" }}
                                  onChange={(e) => handelCharge(e)}
                                />

                                <div class="sepText bg">
                                  <span class="active">{value == "member" ? "booking" : "$"}</span>
                                </div>
                              </div>
                            </div>

                          </div>

                          <div class="xType alignBottom">
                            <div class="fieldGroup mt-0"> {cancellationWindowError && <Error error={cancellationWindowError} />}</div>
                            <div class="fieldGroup mt-0">{chargeError && <Error error={chargeError} />}</div>
                          </div>
                        </div>
                      )}
                    </li>
                  </ul>
                </div>
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a
                  href="javascript:void(0);"
                  class="btn prim fullW"
                  onClick={upDate}
                >
                  Save
                </a>
              </span>
            </div>

            {successMessage && <Success success={successMessage} />}
            {errorMessage && <Error error={errorMessage} />}
          </div>
        </div>
      </Overlay>
    )
  );
};

export default UpdateCancellationCharge;
