import React from 'react'
import Overlay from '../../../utils/Overlay'
import useAxiosIntercept from '../../../hooks/useAxiosIntercept'
import { useState } from 'react'
import Error from '../../UI/Error'
import Success from '../../UI/Success'
export default function UpdateChargeRate({ setupdateChargeRate, membertype, charge_rate, type, configkey, heading, subheading, close, btn_value, setisSuccess, isSuccess }) {
    if (charge_rate == "Free") {
        charge_rate = 0;
    }
    const [value, setValue] = useState(charge_rate);
    const [errorMsg, seterrorMsg] = useState("");
    const [successMessage, setsuccessMessage] = useState("")
    const onbackdropClick = () => {
        document.body.classList.remove('hidden');
        close(false);
    }
    const handleInput = (e) => {
        seterrorMsg("");
        setValue(e.target.value);

    }
    const axiosPrivate = useAxiosIntercept();
    const submit = async () => {

        let body = ""
        const URL = process.env.REACT_APP_UPDATE_CHARGE_AND_TAXES;
        if (configkey == "global_charge_rate") {

            body = {
                config_data: {
                    "site": "admin",
                    "module": "settings",
                    "config_key": configkey,
                    "value": value


                }

            }

        }
        else {

            body = {
                config_data: {
                    "site": "admin",
                    "module": "settings",
                    "config_key": configkey,
                    "value": {
                        "type": type,
                        "value": value

                    }


                }
            }

        }

        const response = await axiosPrivate.post(URL, body);


        if (response?.data?.status == "200") {
            setsuccessMessage("Data updated successfully");
            setisSuccess(!isSuccess)
            setTimeout(() => {
                onbackdropClick();

            }, 2000);
        }
        else {
            seterrorMsg(response?.data?.message)
        }
    }
    return (
        <>

            <Overlay>
                <div class="model_box_child ChargeRatGlobal" id="ChargeRateP_Global" style={{ width: "300px" }}>
                    <div class="ap_heading">
                        <h4>{heading}<span class="material-symbols-rounded black close_model" onClick={onbackdropClick}>close</span></h4>
                    </div>
                    <div class="contentSection">
                        <section class="assignPromoP">
                            <div class="promoText customer">
                                <h4>{membertype}</h4>
                            </div>
                            <div class="addTime dForm">
                                <div class="lists">
                                    <div class="xType alignBottom">
                                        <div class="fieldGroup mr-0">
                                            <em class="smallLabel">{subheading}</em>
                                            <div class="multiOption">
                                                <input type="text" name="" value={value} onChange={handleInput} style={{ width: "70px" }}

                                                />
                                                <div class="sepText bg">
                                                    <span class="active">{type == "P" ? "%" : "$"}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a class="btn prim fullW" onClick={submit}>{btn_value}</a>
                            </span>
                            {errorMsg && <Error error={errorMsg} />}
                            {successMessage && <Success success={successMessage} />}
                        </div>
                    </div>
                </div>

            </Overlay>

        </>
    )
}
