import React from 'react'
import Overlay from '../../../utils/Overlay'
import { useState, useEffect } from 'react'
import useAxiosIntercept from '../../../hooks/useAxiosIntercept';
import Error from '../../UI/Error';
import Success from '../../UI/Success';

export default function UpdateServiceandParkingFee({ membertype, configkey, charge_rate, type, heading, subheading, close, btn_value, setisSuccess, isSuccess }) {

    const axiosPrivate = useAxiosIntercept();
    const [value, setValue] = useState(charge_rate);
    const [feeType, setFeeType] = useState(type);
    const [errorMsg, seterrorMsg] = useState("");
    const [successMessage, setsuccessMessage] = useState("")
    const onbackdropClick = () => {
        document.body.classList.remove('hidden');
        close();

    }

    useEffect(() => {
        setFeeType(type);
    }, [type]);

    const handleFeeType = (e) => {
        setFeeType(e.target.value);
    };

    const submit = async () => {
        const URL = process.env.REACT_APP_UPDATE_CHARGE_AND_TAXES;
        const body = {
            config_data: {
                "site": "admin",
                "module": "settings",
                "config_key": configkey,
                "value": {
                    "type": feeType,
                    "value": value

                }


            }
        }
        const response = await axiosPrivate.post(URL, body);
        if (response?.data?.status == "200") {
            setisSuccess(!isSuccess)
            setsuccessMessage("Data updated successfully");
            setTimeout(() => {
                onbackdropClick();

            }, 2000);
        }
        else {
            seterrorMsg(response?.data?.message)
        }

    }

    const handleInput = (e) => {
        seterrorMsg("");
        setValue(e.target.value);

    }
    return (
        <>
            <Overlay>
                <div class="model_box_child" id="SurchargeServiceFee1" style={{ width: "300px" }}>
                    <div class="ap_heading">
                        <h4>{heading}<span class="material-symbols-rounded black close_model" onClick={onbackdropClick}>close</span></h4>
                    </div>
                    <div class="contentSection">
                        <section class="assignPromoP">
                            <div class="promoText customer">
                                <h4>{membertype}</h4>
                            </div>
                            <div class="addTime dForm">
                                <div class="fieldGroup mr-0">
                                    <em class="smallLabel">Select service fee type</em>
                                    <ul class="yType">
                                        <li>
                                            <input type="radio" id="yTypeRadio1" name="yTypeRadioY" value="inclusive" checked={feeType == "inclusive" && "checked"}
                                                onChange={(e) => handleFeeType(e)}
                                            />
                                            <label for="yTypeRadio1">Inclusive</label>
                                        </li>
                                        <li>
                                            <input type="radio" id="yTypeRadio2" name="yTypeRadioY" value="exclusive" checked={feeType === "exclusive" && "checked"}
                                                onChange={(e) => handleFeeType(e)}
                                            />
                                            <label for="yTypeRadio2">Exclusive</label>
                                            <div class="lists ml-24">
                                                <div class="alignBottom">
                                                    <div class="fieldGroup mt-16">
                                                        <em class="smallLabel">{subheading}</em>
                                                        <div class="multiOption">
                                                            <input type="text" name="" value={value} style={{ width: "70px" }} onChange={handleInput} />


                                                            <div class="sepText bg">
                                                                <span class="active">{type == "P" ? "%" : "$"}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a class="btn prim fullW" onClick={submit}>{btn_value}</a>
                            </span>
                            {errorMsg && <Error error={errorMsg} />}
                            {successMessage && <Success success={successMessage} />}
                        </div>
                    </div>
                </div>

            </Overlay>

        </>
    )
}
