import React from 'react'
import Overlay from '../../../utils/Overlay'
import { useState, useEffect } from 'react'
import useAxiosIntercept from '../../../hooks/useAxiosIntercept';
import Error from '../../UI/Error';
import Success from '../../UI/Success';

export default function UpdateServiceandParkingFee({ membertype, configkey, charge_rate, type, heading, subheading, close, btn_value, setisSuccess, isSuccess }) {
    if (charge_rate == "Free") {
        charge_rate = 0;
    }

    let is_custom_fee = false;
    if (charge_rate == 0) {
        is_custom_fee = false;
    } else if (charge_rate > 0) {
        is_custom_fee = true;
    }
    const axiosPrivate = useAxiosIntercept();
    const [value, setValue] = useState(charge_rate);
    const [errorMsg, seterrorMsg] = useState("");
    const [successMessage, setsuccessMessage] = useState("")
    const [IsCustomFee, setIsCustomFee] = useState(is_custom_fee)
    const onbackdropClick = () => {
        document.body.classList.remove('hidden');
        close();

    }

    useEffect(() => {
        setIsCustomFee(is_custom_fee);
    }, [is_custom_fee]);

    const handleIsCustomFee = (e) => {

        if (e.target.value == 0) {
            setIsCustomFee(false);
            setValue(0);
        } else if (e.target.value == 1) {
            setIsCustomFee(true);
        }

    };

    const submit = async () => {
        const URL = process.env.REACT_APP_UPDATE_CHARGE_AND_TAXES;
        const body = {
            config_data: {
                "site": "admin",
                "module": "settings",
                "config_key": configkey,
                "value": {
                    "type": type,
                    "value": value

                }


            }
        }
        const response = await axiosPrivate.post(URL, body);
        if (response?.data?.status == "200") {
            setisSuccess(!isSuccess)
            setsuccessMessage("Data updated successfully");
            setTimeout(() => {
                onbackdropClick();

            }, 2000);
        }
        else {
            seterrorMsg(response?.data?.message)
        }

    }

    const handleInput = (e) => {
        seterrorMsg("");
        setValue(e.target.value);

    }
    return (
        <>
            <Overlay>
                <div class="model_box_child" id="SurchargeServiceFee1" style={{ width: "300px" }}>
                    <div class="ap_heading">
                        <h4>{heading}<span class="material-symbols-rounded black close_model" onClick={onbackdropClick}>close</span></h4>
                    </div>
                    <div class="contentSection">
                        <section class="assignPromoP">
                            <div class="promoText customer">
                                <h4>{membertype}</h4>
                            </div>
                            <div class="addTime dForm">
                                <div class="fieldGroup mr-0">
                                    <em class="smallLabel">Select service fee type</em>
                                    <ul class="yType">
                                        <li>
                                            <input type="radio" id="yTypeRadio1" name="yTypeRadioY" value="0" checked={IsCustomFee === false && "checked"}
                                                onChange={(e) => handleIsCustomFee(e)}
                                            />
                                            <label for="yTypeRadio1">Free</label>
                                        </li>
                                        <li>
                                            <input type="radio" id="yTypeRadio2" name="yTypeRadioY" value="1" checked={IsCustomFee === true && "checked"}
                                                onChange={(e) => handleIsCustomFee(e)}
                                            />
                                            <label for="yTypeRadio2">Custom fee</label>
                                            {IsCustomFee == true ?
                                                (<div class="lists ml-24">
                                                    <div class="alignBottom">
                                                        <div class="fieldGroup mt-16">
                                                            <em class="smallLabel">{subheading}</em>
                                                            <div class="multiOption">
                                                                <input type="text" name="" value={value} style={{ width: "70px" }} onChange={handleInput} />


                                                                <div class="sepText bg">
                                                                    <span class="active">{type == "P" ? "%" : "$"}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>) : ""
                                            }
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a class="btn prim fullW" onClick={submit}>{btn_value}</a>
                            </span>
                            {errorMsg && <Error error={errorMsg} />}
                            {successMessage && <Success success={successMessage} />}
                        </div>
                    </div>
                </div>

            </Overlay>

        </>
    )
}
