import React from 'react'
import useOutsideClick from '../../../hooks/useOutsideClick';
import Overlay from '../../../utils/Overlay'
import { useEffect } from 'react';
import { useState } from 'react';
import useAxiosIntercept from '../../../hooks/useAxiosIntercept'
import Error from '../../UI/Error';
import Success from "../../UI/Success"
import { Link } from 'react-router-dom';
import { useRef } from 'react';
export default function AddEmployee({ setaddpopup, isSuccess, setisSuccess, setisEmployeeCreated }) {
    const [isSubmit, setisSubmit] = useState(false);
    const axiosPrivate = useAxiosIntercept();
    const [checkOtp, setcheckOtp] = useState(true);
    const [counter, setCounter] = useState(0);
    const [isValid, setisvalid] = useState(false);
    const [otpSent, setotpSent] = useState(false);
    const [otpVerified, setotpverified] = useState(false);
    const [successMessage, setsuccessMessage] = useState("");
    const [otpSuccessMessage, setotpSuccessMessage] = useState("")
    const [handeldropdown, sethandledropdown] = useState(false);
    const [sendotpClicked, setsendotpClicked] = useState(false);
    const [verifyotpClicked, setveriyotpClicked] = useState(false);
    const [label, setlabel] = useState('');
    const [roleInfo, setRoleInfo] = useState({
        role: "",
        id:""
    })
    const [failureMessage, setfailureMessage] = useState("");
    const [userRolesList, setUserRoleList] = useState([]);
    const dropdownref = useRef();
    const handledropdownvalues = (roleDetails) => {
      
        setErrors((prev) => {
            return {
                ...prev, roleError: ""
            }
        })
        setRoleInfo({
            role: roleDetails.role,
            id:roleDetails.role_id
            
        })
       

    }
    const closepopup = () => {
        setaddpopup(false);
        document.body.classList.remove('hidden');
    }
    const [otp, setotp] = useState("");
    const [userData, setuserData] = useState({
        name: "",
        email: "",
        phone: "",
        designation: "",
        role: ""

    })
    const [errors, setErrors] = useState({
        nameError: "",
        emailError: "",
        phoneError: "",
        designationError: "",
        roleError: "",
        otpError: ""

    })
    const verifyOTP = async () => {
        if (otpSent) {

            setErrors((prev) => {
                return {
                    ...prev, phoneError: "", otpError: ""
                }
            })
            setsuccessMessage("")
            setotp("")
            setotpverified(false)
            setotpSent(false)
        }
        setsendotpClicked(true);
        const phoneregex = /^[0-9]{8,10}$/;
        if (userData.phone == "" || !phoneregex.test(userData.phone)) {
            setErrors((prev) => {
                return {
                    ...prev, phoneError: "Enter a valid phone number"
                }
            })

        }
        else {
            setErrors((prev) => {
                return {
                    ...prev, phoneError: ""
                }
            })
            let userListSearchUrl =
                process.env.REACT_APP_GET_ADMIN_LIST + `&search_by=phone&user_type=A&search_keyword=${userData.phone}`;
            const res = await axiosPrivate.get(userListSearchUrl);
            if (res?.data?.status == "200") {
                const records = res?.data?.response?.data?.total_records;
                const sendOtpRequest = {
                    comm_value: userData.phone,
                    object_type: "create_admin",
                };
                if (records == "0") {
                    let sendOtpUrl = process.env.REACT_APP_SEND_OTP;
                    const sendOtpResponse = await axiosPrivate.post(
                        sendOtpUrl,
                        sendOtpRequest
                    );
                    if (sendOtpResponse?.data?.status === 200) {
                        setCounter(30);
                        setotpSuccessMessage("OTP sent successfully")
                        setotpSent(true);
                        setErrors({
                            otpError: ""
                        })

                    } else {
                        setErrors((prev) => {
                            return {
                                ...prev, phoneError: sendOtpResponse?.data?.message
                            }
                        })

                        setcheckOtp(true);
                    }

                }
                else {
                    setErrors((prev) => {
                        return {
                            ...prev, phoneError: "Mobile number already exists"
                        }

                    })
                }

            }

        }


    }
    const validateOTP = async () => {
        setotpSuccessMessage("")
        setveriyotpClicked(true);
        const otpRegex = /^\d{4}$/;
        if (!otpRegex.test(otp)) {
            setErrors((prev) => {
                return {
                    ...prev, otpError: "OTP should be 4 digit long"
                }
            });

        }
        else {
            setErrors((prev) => {
                return {
                    ...prev, otpError: ""
                }
            })
            const validateOTPURL = process.env.REACT_APP_VERIFY_OTP;
            const verifyOtpRequest = {
                comm_value: userData.phone,
                object_type: "create_admin",
                otp: otp,
            };

            const res = await axiosPrivate.post(validateOTPURL, verifyOtpRequest);
            if (res?.data?.status == "200") {
                setotpverified(true);
            }
            else {
                setotpverified(false);
                setErrors((prev) => {
                    return {
                        ...prev, otpError: res?.data?.message
                    }

                })
            }
        }

    }
    const createEmployee = async () => {

        const URL = process.env.REACT_APP_ADD_NEW_CUSTOMER + `&user_type=A`
        const body = {
            name: userData.name,
            email: userData.email,
            phone: userData.phone,
            designation: userData.designation,
            role_id: roleInfo.id
        }
        const response = await axiosPrivate.post(URL, body);
        if (response?.data?.status == "200") {
            setsuccessMessage("Employee created successfully");
            setisEmployeeCreated(true);
            setisSuccess(!isSuccess)
            setTimeout(() => {

                closepopup();

            }, 3000);
        }
        else {
            setfailureMessage(response?.data?.response?.errors[0]?.message)
        }
    }
    const validations = () => {
        var isError = false;
        setisSubmit(true);
        const nameRegex = /^[A-Za-z\s.]*$/;
        const phoneregex = /^[0-9]{8,10}$/;
        const emailRegex = /^[\w-\.]+@([\w-]+\.)+[\w-]{2,4}$/;
        userData.name = userData.name.trim();
        const otpRegex = /^\d{4}$/;
      

        if (userData.name == "" || !nameRegex.test(userData.name)) {
            isError = true;
            setErrors((prev) => {
                return {
                    ...prev, nameError: "Enter a valid name"
                }
            })

        }
        else {
            setErrors((prev) => {
                return {
                    ...prev, nameError: ""
                }
            })
        }
        if (userData.phone == "" || !phoneregex.test(userData.phone)) {
            isError = true;
            setisvalid(false);
            setErrors((prev) => {
                return {
                    ...prev, phoneError: "Enter a valid phone number"
                }
            })

        }
        else {
            
            if (sendotpClicked == false) {
                isError = true;
                setErrors((prev) => {
                    return {
                        ...prev, phoneError: "Kindly click on send OTP button"
                    }
                })

            }
            else {
                setErrors((prev) => {
                    return {
                        ...prev, phoneError: ""
                    }
                })

            }

        }
        if (userData.email == "" || !emailRegex.test(userData.email)) {
            isError = true;
            setisvalid(false);
            setErrors((prev) => {
                return {
                    ...prev, emailError: "Enter a valid email"
                }
            })

        }
        else {
            setErrors((prev) => {
                return {
                    ...prev, emailError: ""
                }
            })
        }
        if (userData.designation == "") {
            isError = true;
            setErrors((prev) => {
                return {
                    ...prev, designationError: "Enter  designation"
                }
            })
        }
        else {
            setErrors((prev) => {
                return {
                    ...prev, designationError: ""
                }
            })
        }
       
        if (verifyotpClicked == false && otpSent == true) {
            setErrors((prev) => {
                return {
                    ...prev, otpError: "Verify OTP first"
                }

            })

        }
        else {
            setErrors((prev) => {
                return {
                    ...prev, otpError: ""
                }

            })

        }
        if (!otpRegex.test(otp)) {
            setErrors((prev) => {
                return {
                    ...prev, otpError: "Enter a valid OTP"
                }
            });

        }
        else {
            setErrors((prev) => {
                if (verifyotpClicked == false)
                    return {
                        ...prev, otpError: "Verify OTP first"
                    }

                else {
                    return {
                        ...prev, otpError: ""
                    }
                }
            })
        }

          if (roleInfo.id == "")
        {
           
            isError = true;
            setErrors((prev) => {
                return {
                    ...prev, roleError: "Please select role"
                }
            })

        }
        else {
                setErrors((prev) => {
                return {
                    ...prev, roleError: ""
                }
            })
        }

        return isError;

    }
    const Submit = () => {
       
        setotpSuccessMessage("")
        var isError = validations();
       
        
        if ( isError==false
            && (errors.otpError == undefined || errors.otpError == "")
           
            && otpSent
            && otpVerified
        ) {
            createEmployee();

        }
        else {
            setisSubmit(false)
        }

    }
    useOutsideClick(dropdownref, () => {
        if (handeldropdown) {
            sethandledropdown(false);

        }

    });

    
    useEffect(() => {
        const getUserRolesList = async () => {
            const userRoleListUrl = process.env.REACT_APP_GET_USER_ROLES_LIST + "&user_type=A";
         
            const userRoleListResponse = await axiosPrivate.get(userRoleListUrl);
            if (userRoleListResponse.status == 200) {
                setUserRoleList(userRoleListResponse?.data?.response?.data);
            }
        }
        getUserRolesList();
    }, []);
    useEffect(() => {
        if (counter > 0) {
            setTimeout(() => {
                setCounter((prev) => prev - 1);
            }, 1000);
        } else {
            setcheckOtp(true);
        }
    }, [counter]);

    return (
        <>
            <Overlay>
                <div class="model_box_child addEmployee" id="addEmployee" style={{ width: "560px" }}>
                    <div class="ap_heading">
                        <h4>
                            Add new employee
                            <span class="material-symbols-rounded black close_model" onClick={closepopup}>
                                close
                            </span>
                        </h4>
                    </div>
                    <div class="contentSection mt-16">
                        <section class="assignPromoP dForm xRow formSection">
                            <div class="fullWidth mr-12">
                                <div class="fieldGroup mt-0">
                                    <label>
                                        Employee name
                                    </label>
                                    <span className={errors?.nameError ? "error" : ""}>
                                        <input placeholder="Enter full name" value={userData.name} type="text" onChange={(e) => { setuserData({ ...userData, name: e.target.value }); setErrors((prev) => { return { ...prev, nameError: "" } }); setfailureMessage("") }} />

                                    </span>
                                    {errors.nameError && <Error error={errors.nameError} />}
                                </div>

                                <div class="fieldGroup">
                                    <label>
                                        Official email ID
                                    </label>
                                    <span className={errors.designationError ? "error" : ""}>
                                        <input placeholder="Enter official email ID" type="text" value={userData.email} onChange={(e) => { setuserData({ ...userData, email: e.target.value }); setErrors((prev) => { return { ...prev, emailError: "" } }); setfailureMessage("") }} />

                                    </span>
                                    {errors.emailError && <Error error={errors.emailError} />}
                                </div>

                                <div class="fieldGroup mobileVerfiy">
                                    <label>
                                        Mobile number
                                    </label>

                                    <span className={errors.phoneError ? "mb-12 error" : ""}>
                                        <input placeholder="Enter mobile number" type="" value={userData.phone} onChange={(e) => { setuserData({ ...userData, phone: e.target.value }); setErrors((prev) => { return { ...prev, phoneError: "" } }); setfailureMessage("") }} minLength={8} maxLength={10} />
                                        <em>
                                            <Link onClick={verifyOTP}
                                                style={{ pointerEvents: counter === 0 && userData.phone != "" ? '' : 'none' }}

                                            >
                                                {otpSent ? counter === 0 ? "Resend OTP" : `Resend otp in ${counter}` : " Send OTP"}

                                            </Link>
                                        </em>

                                    </span>
                                    {errors.phoneError && <Error error={errors.phoneError} />}
                                    <div class="">
                                        {/* <span class="success">
                                            <span class="material-symbols-rounded success mt-xs fill">
                                                check_circle
                                            </span>
                                            Mobile
                                            number verified
                                        </span>
                                        <span class="error">
                                            <span class="material-symbols-rounded error mt-xs fill">
                                                info
                                            </span>
                                            Mobile number
                                            already exists
                                        </span> */}

                                        {otpSent && counter > "0" && <Success success={otpSuccessMessage} />}
                                    </div>
                                    {otpSent && (<> <span class={errors.otpError ? "mb-12 error" : "mb-12"}>
                                        <input name="" placeholder="Enter OTP" type="" value={otp} onChange={(e) => { setotp(e.target.value); setveriyotpClicked(false); setErrors((prev) => { return { ...prev, otpError: "" } }); setfailureMessage("") }} maxLength={4} minLength={4} />
                                    </span>
                                        {errors.otpError && <Error error={errors.otpError} />}
                                        {otpVerified && <Success success={"Mobile number verified"} />}
                                        <span class="">
                                            <a class="btn seco fullWidth" onClick={validateOTP}>
                                                Verify OTP
                                            </a>
                                        </span></>)}

                                    {/* {(<> <span class={errors.otpError ? "mb-12 error" : "mb-12"}>
                                        <input name="" placeholder="Enter OTP" type="" value={otp} onChange={(e) => { setotp(e.target.value); setveriyotpClicked(false); setErrors((prev) => { return { ...prev, otpError: "" } }) }} maxLength={4} minLength={4} />
                                    </span>
                                        {errors.otpError && <Error error={errors.otpError} />}
                                        {otpVerified && <Success success={"Mobile number verified"} />}
                                        <span class="">
                                            <a class="btn seco fullWidth" onClick={validateOTP}>
                                                Verify OTP
                                            </a>
                                        </span></>)} */}

                                </div>
                            </div>

                            <div class="fullWidth ml-12">
                                <div class="fieldGroup mt-0">
                                    <label>
                                        Employee designation
                                    </label>
                                    <span className={errors.designationError ? "error" : ""}>
                                        <input placeholder="Enter designation" type="text" value={userData.designation} onChange={(e) => { setuserData({ ...userData, designation: e.target.value }); setErrors((prev) => { return { ...prev, designationError: "" } }); setfailureMessage("") }} />

                                    </span>
                                    {errors.designationError && <Error error={errors.designationError} />}
                                </div>
                                <div class="fieldGroup">
                                    <label>
                                        Select role
                                    </label>
                                    <div class="multiOption" onClick={() => { sethandledropdown(!handeldropdown) }} ref={dropdownref}>
                                        <div class={handeldropdown ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                            <p>{roleInfo.role ? roleInfo.role : "Select employee role"}

                                                <i class="material-symbols-rounded grey">
                                                    expand_more
                                                </i>
                                            </p>
                                            
                                            <div class="selectDrop" >
                                                <ul class="dropMenu">
                                                    {userRolesList.length != 0 &&
                                                        userRolesList.map((roleList) => {
                                                           
                                                            return (
                                                                <li class={roleList.role_id==roleInfo.id ? "selected" : ""}>
                                                                    <a onClick={()=>handledropdownvalues(roleList)} id="admin">
                                                                        {roleList?.role}
                                                                         {roleList.role_id==roleInfo.id && <i class="material-symbols-rounded">
                                                                            done
                                                                        </i>} 

                                                                    </a>
                                                                </li>
                                                            )

                                                        })
                                                    }
                                                    
                                                    

                                                </ul>
                                            </div>
                                            {errors.roleError && <Error error={errors.roleError} />}
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a class="btn prim" onClick={Submit}>
                                    Add employee
                                </a>
                            </span>
                            {successMessage && <Success success={successMessage} />}
                            {failureMessage && <Error error={failureMessage} />}
                        </div>
                    </div>
                </div>

            </Overlay>

        </>
    )
}