import React from 'react'
import { useRef } from 'react'
import { useState,useEffect } from 'react'
import Overlay from '../../../utils/Overlay'
import useAxiosIntercept from '../../../hooks/useAxiosIntercept'
import Error from '../../UI/Error'
import useOutsideClick from '../../../hooks/useOutsideClick'
import Success from '../../UI/Success'
export default function EditEmployee({ userDetails, seteditpopup, isSuccess, setisSuccess, index, setUsers, users,setisEmployeeEdited }) {
    const axiosPrivate = useAxiosIntercept();
    const [error, setError] = useState("");
    const [success, setSuccess] = useState("");
    const [isSubmit, setisSubmit] = useState(false);
    const [userRolesList, setUserRoleList] = useState([]);
    const [handeldropdown, sethandledropdown] = useState(false);
    const [roleInfo, setRoleInfo] = useState({
        role: userDetails.role,
        id:userDetails.role_id
    })
   
    const dropdownref = useRef();
    const closepopup = () => {
        seteditpopup(false)
        document.body.classList.remove('hidden');
    }
    const [errors, setErrors] = useState({
        nameError: "",
        designationError: "",
        roleError: ""

    })
    const [editFields, seteditFields] = useState({
        name: userDetails.name,
        designation: userDetails.designation,
        role_id: userDetails.role_id

    })
    const [opendropdown, setopendropdown] = useState(false)
    const handledropdown = () => {
        setopendropdown(!opendropdown)
    }

    const edit = async () => {
        const URL = process.env.REACT_APP_EDIT_USER;
        const body = {
            user_id: userDetails.user_id,
            user_data: {
                name: editFields.name,
                designation: editFields.designation,
                role_id:roleInfo.id?roleInfo.id:userDetails.role_id

            }
        }
     
        const response = await axiosPrivate.post(URL, body);

        if (response?.data?.status == "200") {
            setisEmployeeEdited(true);
            setSuccess("User edited successfully");
            let temp = [...users];
            var firstName = editFields.name.split(' ').slice(0, -1).join(' ');
            var lastName = editFields.name.split(' ').slice(-1).join(' ');

            temp[index].firstname = firstName;
            temp[index].lastname = lastName;
            temp[index].designation = editFields.designation;
            temp[index].privilege = editFields.privilege;
            setUsers(temp);
            setTimeout(() => {
                closepopup();
                setisSuccess(!isSuccess)

            }, 3000);

        }
        else {
            setError(response?.data?.response?.errors[0].message)

        }
    }
    const [label, setlabel] = useState('');
     const handledropdownvalues = (roleDetails) => {
      
        setErrors((prev) => {
            return {
                ...prev, roleError: ""
            }
        })
        setRoleInfo({
            role: roleDetails.role,
            id:roleDetails.role_id
            
        })
       

    }
    const Submit = () => {
        let errors_count = validations();
        if (errors_count == 0) {
            edit();
        }
        else {
            setisSubmit(false)
        }

    }

    const validations = () => {
        setisSubmit(true);
        let error_count = 0;
        const nameRegex = /^[A-Za-z\s.]*$/;
        editFields.name = editFields.name.trim();
        editFields.designation = editFields.designation.trim();
        if (editFields.name == "" || !nameRegex.test(editFields.name)) {

            error_count++;
            setErrors((prev) => {
                return {
                    ...prev, nameError: "Enter valid name"
                }

            })
        }
        else {
            setErrors((prev) => {
                return {
                    ...prev, nameError: ""
                }

            })

        }
        if (editFields.designation == "") {

            error_count++;
            setErrors((prev) => {
                return {
                    ...prev, designationError: "Enter Designation"
                }

            })
        }
        else {
            setErrors((prev) => {
                return {
                    ...prev, designationError: ""
                }

            })

        }
        return error_count;
    }
    useOutsideClick(dropdownref, () => {
        if (opendropdown) {
            setopendropdown(false);

        }

    });
    useEffect(() => {
        const getUserRolesList = async () => {
            const userRoleListUrl = process.env.REACT_APP_GET_USER_ROLES_LIST + "&user_type=A";
       
            const userRoleListResponse = await axiosPrivate.get(userRoleListUrl);
            if (userRoleListResponse.status == 200) {
                setUserRoleList(userRoleListResponse?.data?.response?.data);
            }
        }
        getUserRolesList();
    }, []);
    return (
        <>
            <Overlay>
                <div class="model_box_child editEmployee" id="editEmployee" style={{ width: "560px" }}>
                    <div class="ap_heading">
                        <h4>Edit employee details<span class="material-symbols-rounded black close_model" onClick={closepopup}>close</span></h4>
                    </div>
                    <div class="contentSection mt-16">
                        <section class="assignPromoP dForm xRow formSection">
                            <div class="fullWidth mr-12">
                                <div class="fieldGroup mt-0">
                                    <label>Employee name</label>
                                    <span className={errors.nameError ? "error" : ""}>
                                        <input type="text" name="" value={editFields.name} onChange={(e) => { seteditFields({ ...editFields, name: e.target.value }); setErrors((prev) => { return { ...prev, nameError: "" } }) }} />
                                    </span>
                                </div>
                                {errors.nameError && <Error error={errors.nameError} />}
                                <div class="fieldGroup">
                                    <label>Official email ID</label>
                                    <span>
                                        <input type="text" placeholder={userDetails.email} name="" disabled="disabled" />
                                    </span>
                                </div><div class="fieldGroup mobileVerfiy">
                                    <label>Mobile number</label>
                                    <span>
                                        <input type="number" placeholder={userDetails.phone} name="" value="" disabled="disabled" />
                                    </span>



                                </div>
                            </div><div class="fullWidth ml-12">
                                <div class="fieldGroup mt-0">
                                    <label>Employee designation</label>
                                    <span className={errors.designationError ? "error" : ""}>
                                        <input type="text" name="" value={editFields.designation} onChange={(e) => { seteditFields({ ...editFields, designation: e.target.value }); setErrors((prev) => { return { ...prev, designationError: "" } }) }} />
                                    </span>
                                </div>
                                {errors.designationError && <Error error={errors.designationError} />}
                                <div class="fieldGroup">
                                    <label>
                                        Select role
                                    </label>
                                    <div class="multiOption" onClick={() => { sethandledropdown(!handeldropdown) }} ref={dropdownref}>
                                        <div class={handeldropdown ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                            
                                            
                                  <p>{roleInfo.role? roleInfo.role : userDetails.role}

                                                <i class="material-symbols-rounded grey">
                                                    expand_more
                                                </i>
                                            </p>
                     

                                           
                                            <div class="selectDrop" >
                                                <ul class="dropMenu">
                                                    {userRolesList.length != 0 &&
                                                        userRolesList.map((roleList) => {
                                                          
                                                            return (
                                                                <li class={roleList.role_id==roleInfo.id? "selected" : ""}>
                                                                    <a onClick={()=>handledropdownvalues(roleList)} id="admin">
                                                                        {roleList?.role}
                                                                         {roleList.role_id==roleInfo.id && <i class="material-symbols-rounded">
                                                                            done
                                                                        </i>} 

                                                                    </a>
                                                                </li>
                                                            )

                                                        })
                                                    }
                                                    
                                                    

                                                </ul>
                                            </div>
                                            {errors.roleError && <Error error={errors.roleError} />}
                                        </div>
                                    </div>
                                </div>



                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a onClick={Submit} class="btn prim">Update details</a>
                            </span>
                        </div>
                        {error && <Error error={error} />}
                        {success && <Success success={success} />}
                    </div>
                </div>

            </Overlay>

        </>
    )
}
