import React from 'react'
import { useState, useEffect, useRef } from 'react'
import useAxiosIntercept from '../../../hooks/useAxiosIntercept';
import EmployeesListing from './EmployeesListing';
import Pagination from '../../Customer/Pagination';
import useHttp from '../../../hooks/useHttp';
import usePaginate from '../../../hooks/usePaginate';
import NoData from '../../UI/NoData';
import Loading from '../../UI/Loading';
import NoPriviliges from '../../UI/NoPriviliges';
import useAuth from '../../../hooks/useAuth';
export default function Employees({ }) {
    const axiosPrivate = useAxiosIntercept();
    const { auth } = useAuth();
    const [isSuccess, setisSuccess] = useState(false);
    const [isEmployeeCreated, setisEmployeeCreated] = useState(false);
    const [isEmployeeEdited, setisEmployeeEdited] = useState(false);
    const prevSuccess = useRef({ isEmployeeCreated }).current;
    const prevIsSuccess = useRef({ isEmployeeEdited}).current;
    const [hasMore, setHasMore] = useState(false);
    const [users, setUsers] = useState("");
    const [currentPage, setCurrentPage] = useState(1);
    const [usersPerPage, setUsersPerPage] = useState(5);
    const [total_records, setTotalRecords] = useState(0);
    const [eventInitiated, setEventInitiated] = useState(false);
    const perpageLimit = 10;
    const [pageNumber, setPageNumber] = useState(1);
    const { isLoading, sendRequest: getEmployeeList } = useHttp();
    const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);
    let url = process.env.REACT_APP_GET_ADMIN_LIST + `&user_type=A&page=${pageNumber}&limit=${perpageLimit}`
    useEffect(() => {
        const setEmployeeList = (employees) => {
            const { data } = employees?.data?.response;

            if (data?.user_info) {
                if (prevSuccess.isEmployeeCreated !== isEmployeeCreated || prevIsSuccess.isEmployeeEdited != isEmployeeEdited) {
                   
                    setUsers(() => {
                        return ([...new Set([...data?.user_info])])

                    })
                } else {
                  
                    setUsers((prev) => {

                        return [...new Set([...prev, ...data?.user_info])]

                    });
                }
                setTotalRecords(data?.total_records);
                setisEmployeeCreated(false);
                setisEmployeeEdited(false);

            }
            else {
                setUsers({})
            }
            if (data?.total_records == data?.user_info?.length) {
                setHasMore(false);
            }
            else {

                setHasMore(employees?.data?.response?.data?.user_info?.length > 0);
            }
        }
        if (pageNumber == 1 || (Math.ceil(total_records / perpageLimit) >= pageNumber)) {

            getEmployeeList(
                {
                    url
                },
                setEmployeeList

            );
        }


    }, [url, isSuccess, getEmployeeList, pageNumber])

    return (
        <>
            
            {auth.priviliges.includes("read_employee_settings") ?
                <EmployeesListing users={users} setUsers={setUsers} isSuccess={isSuccess} setisSuccess={setisSuccess}
                    lastElementRef={lastElementRef} setisEmployeeCreated={setisEmployeeCreated} setisEmployeeEdited={setisEmployeeEdited}
                /> :<NoPriviliges/>}
            <div>{isLoading && pageNumber != "1" && <Loading />}</div>
            {pageNumber != "1" && pageNumber > Math.ceil(total_records / perpageLimit) && (<NoData />)}

        </>
    )
}
