import React from 'react'
import useAuth from '../../../hooks/useAuth';
import { useState } from 'react';
import { Link } from 'react-router-dom';
import EditEmployee from './EditEmployee';
import DeleteEmployee from './DeleteEmployee';
import Spinner from '../../UI/Spinner';
import AddEmployee from './AddEmployee';
import DataNotFound from '../../UI/DataNotFound';
import NoPriviliges from '../../UI/NoPriviliges';
export default function EmployeesListing({ users, setUsers, isSuccess, setisSuccess, lastElementRef, setisEmployeeCreated ,setisEmployeeEdited}) {
    const { auth } = useAuth();
    const [editpopup, seteditpopup] = useState(false);
    const [index, setIndex] = useState("")
    const [deletepopUp, setdeletepopup] = useState(false);
    const [addpopup, setaddpopup] = useState(false);
    const [userDetails, setuserDetails] = useState({
        name: '',
        designation: "",
        email: "",
        phone: "",
        role: ""

    })
  
    const isRootValue = auth?.userIsRoot;
   
    const isRoot = isRootValue.toLowerCase();
    const [notifyData, setNotifyData] = useState();
    const editAdmin = (name, user, index) => {
     
        setIndex(index);
        seteditpopup(true);
        setuserDetails({
            name: name,
            designation: user.designation,
            email: user.email,
            phone: user.phone,
            role: user.role,
            user_id: user.user_id,
            is_root: user.is_root,
            role_id:user.role_id

        })

    }
    const deleteAdmin = (id, name, designation, index) => {
        setNotifyData({
            index: index,
            heading: "Are you sure you want to delete employee?",
            name: name,
            text: designation,
            buttonNameYes: "Yes,delete",
            buttonNameNo: "No,don't delete",
            success: "Employee deleted successfully",
            url: process.env.REACT_APP_EDIT_USER,
            apiRequest: {
                "user_id": id,
                "user_data": {
                    "status": "X"
                }

            },
        })
        setdeletepopup(true)
    }
    const addEmployee = () => {
        setaddpopup(true)

    }

    return (
        <>

            {editpopup && <EditEmployee userDetails={userDetails} seteditpopup={seteditpopup} isSuccess={isSuccess} setisSuccess={setisSuccess} index={index} users={users} setUsers={setUsers} setisEmployeeEdited={setisEmployeeEdited} />}
            {deletepopUp && <DeleteEmployee notifyData={notifyData} setdeletepopup={setdeletepopup} users={users} setUsers={setUsers} />}
            {addpopup && <AddEmployee setaddpopup={setaddpopup} isSuccess={isSuccess} setisSuccess={setisSuccess} users={users} setUsers={setUsers} setisEmployeeCreated={setisEmployeeCreated} />}
            <div class="mt-24">
                <div class="searchPanel mb-24">
                    <h3>Employees</h3>
                                     {auth.priviliges.includes("write_employee_settings") &&

                    <a onClick={addEmployee} class="btn prim open_model" data-target="addEmployee">Add new employee</a>}

                </div>
                {auth.priviliges.includes("read_employee_settings") ?

                    users == "" ? <Spinner /> : Object.keys(users).length != "0" ? (<>
                        <div class="dataTableDynamic">

                            <table>
                                <tbody>
                                    <tr>
                                        <th>Name</th>
                                        <th>Designation</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Role</th>
                                        {auth.priviliges.includes("write_employee_settings") && <th>&nbsp;</th>}
                                    </tr>
                                    {users && users?.length > 0 ?
                                        users.map((user, index) => {
                                            let fullName = "";
                                            fullName = user.firstname ? fullName + " " + user.firstname : "";
                                            fullName = user.lastname ? fullName + " " + user.lastname : fullName;
                                            if (users?.length == index + 1) {
                                                return (<>

                                                    <tr ref={lastElementRef} key={index}>
                                                        <td class="vName"><span>{fullName ? fullName : "Guest"}</span></td>
                                                        <td>{user.designation}</td>
                                                        <td>{user.email ? user.email : "N/A"}</td>
                                                        <td>{user.phone}</td>
                                                        <td class="status">{user.role}</td>
                                                       
                                                        {auth.priviliges.includes("write_employee_settings") &&

                                                            <td class="right">
                                                                { <div class="actionNav">
                                                                    <i class="material-symbols-rounded mt-m grey">more_vert</i>
                                                                    <div class="dropMenuWrap">
                                                                        <ul class="dropMenu" style={{ width: "180px" }}>
                                                                            <li>
                                                                                <Link class="open_model" data-target="editEmployee" onClick={() => { editAdmin(fullName,user, index) }}>Edit</Link>
                                                                            </li>
                                                                            <li>
                                                                                <Link class="error open_model" data-target="deleteEmp" onClick={() => { deleteAdmin(user.user_id, fullName, user.designation, index) }}>Delete</Link>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div> }

                                                            </td>}
                                                    </tr>

                                                </>)


                                            }
                                            else {
                                                return (<>

                                                    <tr ref={lastElementRef} key={index}>
                                                        <td class="vName"><span>{user.firstname ? fullName : "Guest"}</span></td>
                                                        <td>{user.designation}</td>
                                                        <td>{user.email ? user.email : "N/A"}</td>
                                                        <td>{user.phone}</td>
                                                        <td class="status">{user.role}</td>
                                                        {auth.priviliges.includes("write_employee_settings") &&
                                                            <td class="right">
                                                                { <div class="actionNav">
                                                                    <i class="material-symbols-rounded mt-m grey">more_vert</i>
                                                                    <div class="dropMenuWrap">
                                                                        <ul class="dropMenu" style={{ width: "180px" }}>
                                                                            <li>
                                                                                <Link class="open_model" data-target="editEmployee" onClick={() => { editAdmin(fullName, user, index) }}>Edit</Link>
                                                                            </li>
                                                                            <li>
                                                                                <Link class="error open_model" data-target="deleteEmp" onClick={() => { deleteAdmin(user.user_id, fullName, user.designation, index) }}>Delete</Link>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>}

                                                            </td>}
                                                    </tr>

                                                </>)

                                            }



                                        })



                                        : ""}

                                </tbody>
                            </table>
                        </div>
                    </>) : (<><section>
                        <div className="head">
                            <p>No Employee Found</p>
                        </div>
                    </section></>) : <NoPriviliges message="no priviliges" />}

            </div>

        </>
    )
}
