import React from "react";
import { useState } from "react";
import Overlay from "../../../utils/Overlay";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Success from "../../UI/Success";
import Error from "../../UI/Error";
const AddBatterySize = ({
  onBackdropClick,
  closePopup,
  batterySize,
  success,
  setSuccess,
}) => {
  const axiosPrivate = useAxiosIntercept();

  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");

  const handelClose = () => {
    onBackdropClick();
    setFields([
      {
        key: Date.now(),
        operator: "",
        data: {
          maximum_battery_unit: "",
          minimum_battery_unit: "",
        },
      },
    ]);
  };
  const [fields, setFields] = useState([
    {
      key: Date.now(),
      operator: "",
      data: {
        maximum_battery_unit: "",
        minimum_battery_unit: "",
      },
    },
  ]);
  const [lessCheckedIcon, setLessCheckedIcon] = useState(true);
  const [greaterCheckedIcon, setGreaterCheckedIcon] = useState("");
  const [maxSizeLabel, setMaxSizeLabel] = useState([]);
  const [minSizeLabel, setMinSizeLabel] = useState([]);
  const [checkedIcon, setCheckedIcon] = useState("");
  const [addsize, setAddSize] = useState("");
  const handelLessCheckedIcon = (e, i) => {
    setLessCheckedIcon({ ...lessCheckedIcon, [i]: !lessCheckedIcon[i] });
  };
  const handelGreaterCheckedIcon = (e, i) => {

    setGreaterCheckedIcon({
      ...greaterCheckedIcon,
      [i]: !greaterCheckedIcon[i],
    });
  };

  const addAnotherSize = () => {

    setFields((previousFields) => [
      ...previousFields,
      {
        key: Math.random(),
        operator: "",
        data: {
          maximum_battery_unit: "",
          minimum_battery_unit: "",
        },
      },
    ]);
  };
  const deleteField = (e, i, id) => {

    const filtered = fields.filter((obj) => {

      return obj.key !== id;
    });
    setMaxSizeLabel([]);
    setMinSizeLabel([]);
    setFields(filtered);
  };
  const handelMinSize = (e, index) => {

    const labels = [...minSizeLabel];

    labels[index] = e.target.value;
    const values = [...fields];
    values[index]["operator"] =
      lessCheckedIcon[index] && greaterCheckedIcon[index]
        ? "-"
        : greaterCheckedIcon[index]
          ? "<"
          : lessCheckedIcon[index]
            ? ">"
            : "";

    values[index].data["minimum_battery_unit"] = e.target.value;
    values[index].error =
      e.target.value < 0 ? { minimum: "Value must be greater tham 0." } : {};

    // values[index].data["minimum_battery_unit"] = "0";
    setMinSizeLabel(labels);
  };
  const handelMaxSize = (e, index) => {

    const labels = [...maxSizeLabel];
    const values = [...fields];
    values[index]["operator"] =
      lessCheckedIcon[index] && greaterCheckedIcon[index]
        ? "-"
        : greaterCheckedIcon
          ? "<"
          : lessCheckedIcon[index]
            ? ">"
            : "";

    values[index].data["maximum_battery_unit"] = e.target.value;
    values[index].error =
      e.target.value < 0 ? { maximum: "Value must be greater tham 0." } : {};
    labels[index] = e.target.value;
    setMaxSizeLabel(labels);
  };

  const handleSubmit = async () => {
    let errorData = false;
    // for (var i = 0; i < newArray.length; i++) {
    //   delete newArray[i]["key"];

    //   console.log(minSizeLabel);
    // }
    // let dataArray = new Array();
    let mainArray = fields.map((item) => {
      if (item.operator === "") {
        errorData = true;
        return {
          ...item,
          error: { empty: "Please select atleast one field." },
        };
      } else if (item.data.minimum_battery_unit < 0) {
        errorData = true;
        return {
          ...item,
          error: { minimum: "Value must be greater tham 0." },
        };
      } else if (item.data.maximum_battery_unit < 0) {
        errorData = true;
        return {
          ...item,
          error: { maximum: "Value must be greater tham 0." },
        };
      } else {
        return { ...item };
      }
    });
    setFields(mainArray);

    if (!errorData) {

      const newArray = batterySize.concat(fields);

      const request = {
        config_data: {
          site: "admin",
          module: "settings",
          config_key: "battery_type",
          value: newArray.map((itemData) => ({
            data: itemData.data,
            operator: itemData.operator,
          })),
        },
      };

      const url = process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
      const response = await axiosPrivate.post(url, request);

      setSuccessMessage("");

      if (response?.data?.status === 200) {
        setErrorMessage("");
        setSuccessMessage(response?.data?.message);
        setTimeout(() => {
          setSuccessMessage("");
          setErrorMessage("");
          setMaxSizeLabel([]);
          setMinSizeLabel([]);
          setLessCheckedIcon({});
          setGreaterCheckedIcon({});
          onBackdropClick(true);
          setSuccess(!success);
          setFields([
            {
              key: Date.now(),
              operator: "",
              data: {
                maximum_battery_unit: "",
                minimum_battery_unit: "",
              },
            },
          ]);
        }, 3000);
      } else {

        setErrorMessage(response?.data?.message);
      }


    }
  };


  return (
    closePopup && (
      <Overlay>
        <div
          class="model_box_child manageBookingTimeP AddBattery"
          id="manageBookingTimeP_AddBattery"
          style={{ width: "500px" }}
        >
          <div class="ap_heading">
            <h4>
              Add new battery size
              <span
                class="material-symbols-rounded black close_model"
                onClick={handelClose}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section>
              <div class="addTime dForm">
                {fields.map((batterySize, i) => {
                  return (
                    <>
                      <div
                        class="xType alignBottom "
                        style={{ marginBottom: "15px" }}
                      >
                        <div class="fieldGroup mt-0">
                          <em class="smallLabel">
                            <i
                              class="material-symbols-rounded activeFill mr-8"
                              id="lessThan"
                              onClick={(e) => handelLessCheckedIcon(e, i)}
                            >
                              {lessCheckedIcon[i] === true
                                ? "check_circle"
                                : "radio_button_unchecked"}
                            </i>{" "}
                            Less than/Minimum
                          </em>
                          <div class="multiOption">
                            <input
                              type="number"
                              placeholder="Enter battery size"
                              name="minSize"
                              value={minSizeLabel[i]}
                              onChange={(e) => handelMinSize(e, i)}
                              disabled={
                                lessCheckedIcon[i] === true ? false : true
                              }
                            />
                            <div class="sepText bg">
                              <span>kWH</span>
                            </div>
                          </div>
                          {batterySize.error?.minimum ? (
                            <Error error={batterySize.error?.minimum} />
                          ) : null}
                        </div>
                        <div class="fieldGroup mt-0">
                          <em class="smallLabel">
                            <i
                              class="material-symbols-rounded activeFill  mr-8"
                              id="greaterThan"
                              onClick={(e) => handelGreaterCheckedIcon(e, i)}
                            >
                              {greaterCheckedIcon[i] === true
                                ? "check_circle"
                                : "radio_button_unchecked"}
                            </i>
                            Greater than/Maximum
                          </em>
                          <div class="multiOption">
                            <input
                              type="number"
                              placeholder="Enter battery size"
                              name="maxSize"
                              value={maxSizeLabel[i]}
                              onChange={(e) => handelMaxSize(e, i)}
                              disabled={
                                greaterCheckedIcon[i] === true ? false : true
                              }
                            />
                            <div class="sepText bg">
                              <span>kWH</span>
                            </div>
                          </div>
                          {batterySize.error?.maximum ? (
                            <Error error={batterySize.error?.maximum} />
                          ) : null}
                        </div>
                        <div
                          class="fieldGroup"
                          onClick={(e) => deleteField(e, i, batterySize.key)}
                        >
                          <i class="material-symbols-rounded mt-m">delete</i>
                        </div>
                      </div>
                      {batterySize.error?.empty &&
                        batterySize.data.minimum_battery_unit === "" &&
                        batterySize.data.maximum_battery_unit === "" ? (
                        <Error error={batterySize.error?.empty} />
                      ) : null}
                    </>
                  );
                })}

                <div class="link" onClick={addAnotherSize}>
                  <i class="material-symbols-rounded mt-m activeFill">
                    battery_charging_30
                  </i>
                  <a href="javascript:void(0);">Add another size</a>
                </div>
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a
                  href="javascript:void(0);"
                  class="btn prim fullW"
                  onClick={handleSubmit}
                >
                  Add battery size
                </a>
              </span>
            </div>

            {successMessage ? <Success success={successMessage} /> : <></>}
            {errorMessage ? <Error error={errorMessage} /> : <></>}
          </div>
        </div>
      </Overlay>
    )
  );
};

export default AddBatterySize;
