import React from "react";
import { useState } from "react";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import { messages } from "../../../configuration/GlobalConfig";
import responseHandler from "../../../services/responseHandler";
import { useEffect } from "react";
import AddBatterySize from "./AddBatterySize";
import ManageBatterySize from "./ManageBatterySize";
import useAuth from "../../../hooks/useAuth";
const BatterySize = ({ hideSettings,
  handleHideSettings }) => {
  const { auth } = useAuth();
  const [batterySize, setBatterySize] = useState([]);
  const [closePopup, setClosePopup] = useState(false);
  const [error, setError] = useState("");
  const [success, setSuccess] = useState(false);
  const [showPopup, setShowPopup] = useState({
    addSize: false,
    manageSize: false,
  });
  const onBackdropClick = () => {
    setClosePopup(false);
    document.body.classList.remove('hidden');
  };
  const axiosPrivate = useAxiosIntercept();
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    let response = {};
    const getAttendantIncentive = async () => {
      let URL = process.env.REACT_APP_GET_ATTENDANT_INCENTIVE;
      const request = {
        config_data: [
          {
            site: "admin",
            module: "settings",
            config_key: "battery_type",
          },
        ],
      };

      try {
        const { data } = await axiosPrivate.post(URL, request);

        if (data?.status === 200 && isMounted) {
          response = responseHandler(data, "API_SUCCESS");

          let json_value = response.response.data[0].value;

          let json_obj = JSON.parse(json_value);

          setBatterySize(json_obj);
          //   // setTotalRecords(response.response.data.total_records);
        } else {
          response = responseHandler(data, "API_ERROR");
          //Handler Error Here...
          setError(messages.API_ERROR);
        }
      } catch (err) {
        response = responseHandler(err, "NETWORK_ERROR");
        //Handler Error Here...
        setError(messages.NETWORK_ERROR);
      }
    };

    isMounted && getAttendantIncentive();

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [success]);
  const openPopup = (e) => {
    setShowPopup({ [e.currentTarget.id]: true });
    setClosePopup(true);
  };

  return (
    <>
      <div class="boxT1">
        <div class="item">
          <div class="text">
            <h4>Battery size</h4>
            <span>Manage the battery size range of vehicles</span>
          </div>
          {auth.priviliges.includes("write_settings") &&
            <div class="headingButtons">
              <a
                href="javascript:void(0);"
                class="btn seco open_model"
                data-target="manageBookingTimeP_BatterySize"
                id="manageSize"
                onClick={(e) => openPopup(e)}
              >
                Manage sizes
              </a>
              <a
                href="javascript:void(0);"
                class="btn prim open_model"
                data-target="manageBookingTimeP_AddBattery"
                id="addSize"
                onClick={(e) => openPopup(e)}
              >
                Add new size
              </a>
            </div>}
          <i className={hideSettings.battery_size === true ? "material-symbols-rounded arrowBottom mt-l" : "material-symbols-rounded arrowTop mt-l"}
            onClick={() => handleHideSettings("battery_size")}
          >expand_more</i>
        </div>
        <div className="tableList mt-16">

          <div>
            <ul className="tabsList ml-0" style={hideSettings.battery_size === true ? {
              display: "none"
            } : {
            }}>
              {batterySize ? (
                batterySize.map((sizes) => {
                  const { operator, data } = sizes;
                  return operator === "<" ? (
                    <li>{`${operator}${data.maximum_battery_unit} kWh`}</li>
                  ) : operator === "-" ? (
                    <li>{`${data.minimum_battery_unit}${operator}${data.maximum_battery_unit} kWh`}</li>
                  ) : (
                    <li>{`${operator}${data.minimum_battery_unit} kWh`}</li>
                  );
                })
              ) : (
                <></>
              )}
            </ul>
          </div>
        </div>
        {showPopup.addSize && (
          <AddBatterySize
            onBackdropClick={onBackdropClick}
            closePopup={closePopup}
            batterySize={batterySize}
            setSuccess={setSuccess}
            success={success}
          />
        )}
        {showPopup.manageSize && (
          <ManageBatterySize
            batterySize={batterySize}
            onBackdropClick={onBackdropClick}
            closePopup={closePopup}
            setBatterySize={setBatterySize}
            success={success}
          />
        )}
      </div>
    </>
  );
};

export default BatterySize;
