import React from "react";
import { useState } from "react";
import { Link } from "react-router-dom";
import { FormatDate } from "../../../utils/FormatDate";
import { Time } from "../../../utils/Time";
import { SettingTime } from "../SettingTime";
import ManageBookingTime from "./ManageBookingTime";
import ManageBookingTimeEmergency from "./ManageBookingTimeEmergency";
import ManageCorporateBookingTime from "./ManageCorporateBookingTime";
import { HourMapping } from "../../../configuration/createPackageFormConfigs";
import useAuth from "../../../hooks/useAuth";
const BookingTime = ({
  bookingProfile,
  success,
  setSuccess,
  setBookingProfile,
  hideSettings,
  handleHideSettings,
}) => {
  const { auth } = useAuth();
  const [openPopup, setOpenPopup] = useState(false);
  const [value, setValue] = useState("");
  const [showPopup, setShowPopup] = useState({
    customers: false,
    corporate: false,
    partner: false,
    emergency: false,
  });

  const onBackdropClick = () => {
    document.body.classList.remove("hidden");
    setOpenPopup(false);
  };
  const handelBookingTimePopup = (e) => {
    setShowPopup({ [e.currentTarget.id]: true });
    setValue(e.currentTarget.id);
    setOpenPopup(true);
  };
  var time = "";
  return (
    <>
      <div class="boxT1">
        <div class="item">
          <div class="text">
            <h4>Booking time</h4>
            <span>Manage the booking times of all customer types</span>
          </div>
          <i className={hideSettings.booking_time === true ? "material-symbols-rounded arrowBottom mt-l" : "material-symbols-rounded arrowTop mt-l"} 
            onClick={() => handleHideSettings("booking_time")}      
        >expand_more</i>
        </div>
        <div class="tableList mt-16" style={hideSettings.booking_time === true ? {
            display:"none"
        } : {
            display:"block"
        }}>
          <div>
            <table class="widthAuto">
              <tbody>
                <tr>
                  <td>
                    <span>Direct customers</span>
                    <>
                      {/* {(time = "")}
                        {bookingProfile?.booking_time_customers.map(
                          (bookingTimeCustomers) => {
                            time =
                              time +
                              SettingTime(bookingTimeCustomers?.from_time) +
                              " - " +
                              SettingTime(bookingTimeCustomers?.to_time) +
                              ", ";
                          }
                        )} */}
                      <span class="time">
                        {/* {console.log(time.substring(0, 36))}
                          {console.log(time.substring(0, time.length - 2))} */}
                        {bookingProfile?.direct_customers?.data[0]
                          ? SettingTime(
                              bookingProfile?.direct_customers?.data[0]
                                ?.package_operating_start_time
                            ) +
                            " - " +
                            SettingTime(
                              bookingProfile?.direct_customers?.data[0]
                                ?.package_operating_end_time
                            )
                          : null}
                        {auth.priviliges.includes("write_settings") &&
                          <a
                            class="open_model"
                            id="customers"
                            data-target="manageBookingTimeP_Partners"
                            onClick={(e) => handelBookingTimePopup(e)}
                          >
                            Manage
                          </a>}
                      </span>
                    </>
                  </td>
                  <td>
                    <span>Partners</span>
                    {
                      <>
                        {/* {(time = "")}
                        {bookingProfile?.booking_time_partner.map(
                          (bookingTimePartner) => {
                            time =
                              time +
                              SettingTime(bookingTimePartner?.from_time) +
                              " - " +
                              SettingTime(bookingTimePartner?.to_time) +
                              ", ";
                          }
                        )} */}
                        <span class="time">
                          {bookingProfile?.partners?.data[0]
                            ? SettingTime(
                                bookingProfile?.partners?.data[0]
                                  ?.package_operating_start_time
                              ) +
                              " - " +
                              SettingTime(
                                bookingProfile?.partners?.data[0]
                                  ?.package_operating_end_time
                              )
                            : null}
                          {auth.priviliges.includes("write_settings") &&
                            <a
                              class="open_model"
                              data-target="manageBookingTimeP_Partners"
                              onClick={(e) => handelBookingTimePopup(e)}
                              id="partner"
                            >
                              Manage
                            </a>}
                        </span>
                      </>
                    }
                  </td>
                  <td>
                    <span>Corporate</span>
                    {bookingProfile && bookingProfile?.corporate ? (
                      <>
                        {(time = "")}
                        {bookingProfile?.corporate.data.map(
                          (bookingTimeCorporate) => {
                            time =
                              time +
                              SettingTime(
                                bookingTimeCorporate?.package_operating_start_time
                              ) +
                              " - " +
                              SettingTime(
                                bookingTimeCorporate?.package_operating_end_time
                              ) +
                              ", ";
                          }
                        )}
                        <span class="time">
                          {time.substring(0, time.length - 2)}
                          {auth.priviliges.includes("write_settings") &&
                            <a
                              class="open_model"
                              data-target="manageBookingTimeP_Partners"
                              onClick={(e) => handelBookingTimePopup(e)}
                              id="corporate"
                            >
                              Manage
                            </a>}
                        </span>
                      </>
                    ) : (
                      <></>
                    )}
                  </td>
                  <td>
                    <span>Emergency</span>
                    <span class="time">
                      {bookingProfile?.emergency?.data[0]
                        ?.package_operating_start_time ? (
                        <>
                          {SettingTime(
                            bookingProfile?.emergency?.data[0]
                              ?.package_operating_start_time
                          ) +
                            " - " +
                            SettingTime(
                              bookingProfile?.emergency?.data[0]
                                ?.package_operating_end_time
                            )}
                        </>
                      ) : (
                        <>24 hours</>
                      )}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          class="open_model"
                          data-target=""
                          id="emergency"
                          onClick={(e) => handelBookingTimePopup(e)}
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
        {showPopup?.partner && (
          <ManageBookingTime
            bookingProfile={bookingProfile}
            value={value}
            onBackdropClick={onBackdropClick}
            openPopup={openPopup}
            success={success}
            setSuccess={setSuccess}
          />
        )}
        {showPopup?.customers && (
          <ManageBookingTime
            bookingProfile={bookingProfile}
            value={value}
            onBackdropClick={onBackdropClick}
            openPopup={openPopup}
            success={success}
            setSuccess={setSuccess}
          />
        )}
        {showPopup?.corporate && (
          <ManageCorporateBookingTime
            bookingProfile={bookingProfile}
            value={value}
            onBackdropClick={onBackdropClick}
            openPopup={openPopup}
            success={success}
            setSuccess={setSuccess}
            setBookingProfile={setBookingProfile}
          />
        )}
        {showPopup?.emergency && (
          <ManageBookingTimeEmergency
            onBackdropClick={onBackdropClick}
            bookingProfile={bookingProfile}
            value={value}
            success={success}
            setSuccess={setSuccess}
            openPopup={openPopup}
          />
        )}
      </div>
    </>
  );
};

export default BookingTime;
