import React from "react";
import { useState } from "react";
import { HourMapping } from "../../../configuration/createPackageFormConfigs";
import ManageBookingWindow from "./ManageBookingWindow";
import { useEffect } from "react";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import responseHandler from "../../../services/responseHandler";
import { messages } from "../../../configuration/GlobalConfig";
import ManageBookingWindowEmergency from "./ManageBookingWindowEmergency";
import useAuth from "../../../hooks/useAuth";
const BookingWindow = ({ bookingProfile, hideSettings,
  handleHideSettings }) => {
  const axiosPrivate = useAxiosIntercept();
  const [bookingWindow, setBookingWindow] = useState([]);
  const [error, setError] = useState("");
  const [success, setSuccess] = useState(false);
  const [openPopup, setOpenPopup] = useState(false);
  const { auth } = useAuth();
  const [bookingWindowPopup, setBookingWindowPopup] = useState({
    bookingWindow: false,
    emergency: false,
  });
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    let response = {};
    const getAttendantIncentive = async () => {
      let URL = process.env.REACT_APP_GET_ATTENDANT_INCENTIVE;
      const request = {
        config_data: [
          {
            site: "admin",
            module: "settings",
            config_key: "booking_window",
          },
        ],
      };
      try {
        const { data } = await axiosPrivate.post(URL, request);

        if (data?.status === 200 && isMounted) {
          response = responseHandler(data, "API_SUCCESS");
          let json_value = response?.response?.data[0].value;
          let jsonObj = JSON.parse(json_value);


          setBookingWindow(jsonObj);
        } else {
          response = responseHandler(data, "API_ERROR");
          //Handler Error Here...
          setError(messages.API_ERROR);
        }
      } catch (err) {
        response = responseHandler(err, "NETWORK_ERROR");
        //Handler Error Here...
        setError(messages.NETWORK_ERROR);
      }
    };

    isMounted && getAttendantIncentive();

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [success]);
  const handelBookingWindow = (e) => {

    setBookingWindowPopup({
      [e.currentTarget.id]: true,
    });
    setOpenPopup(true);
  };
  const onBackdropClick = () => {
    document.body.classList.remove("hidden");
    setBookingWindowPopup({ bookingWindow: false });
    setOpenPopup(false);
  };
  return (
    <>
      <div class="boxT1">
        <div class="item">
          <div class="text">
            <h4>Booking window</h4>
            <span>Manage the booking window</span>
          </div>
          <i className={hideSettings.booking_window === true ? "material-symbols-rounded arrowBottom mt-l" : "material-symbols-rounded arrowTop mt-l"}
            onClick={() => handleHideSettings("booking_window")}
          >expand_more</i>
        </div>
        <div class="tableList mt-16" style={hideSettings.booking_window === true ? {
          display: "none"
        } : {
          display: "block"
        }}>
          <div>
            <table class="widthAuto">
              <tbody>
                <tr>
                  <td>
                    <span>Global</span>
                    <span class="time">
                      {/* {console.log(
                        HourMapping?.[
                        bookingProfile?.global?.minimum_time?.unit
                        ]
                      )} */}
                      {bookingWindow ? (
                        <>
                          {bookingWindow?.global && (
                            <>
                              Min. {bookingWindow?.global?.minimum_time.value}{" "}
                              {
                                HourMapping?.[
                                bookingWindow?.global?.minimum_time.unit
                                ]
                              }{" "}
                              - Max. {bookingWindow?.global?.maximum_time.value}{" "}
                              {
                                HourMapping?.[
                                bookingWindow?.global?.maximum_time.unit
                                ]
                              }
                              {auth.priviliges.includes("write_settings") &&
                                <a
                                  class="open_model"
                                  href="javascript:void(0);"
                                  data-target="manageBookingWindowP_Global"
                                  id="bookingWindow"
                                  onClick={(e) => handelBookingWindow(e)}
                                >
                                  Manage
                                </a>}
                            </>
                          )}
                        </>
                      ) : (
                        <></>
                      )}
                    </span>
                  </td>
                  <td>
                    <span>Emergency</span>
                    <span class="time">
                      {bookingWindow?.emergency?.maximum_time?.value}{" "}
                      {
                        HourMapping?.[
                        bookingWindow?.emergency?.maximum_time?.unit
                        ]
                      }
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          href="javascript:void(0);"
                          class="open_model"
                          data-target="m"
                          id="emergency"
                          onClick={(e) => handelBookingWindow(e)}
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
        {bookingWindowPopup.bookingWindow && (
          <ManageBookingWindow
            onBackdropClick={onBackdropClick}
            bookingWindow={bookingWindow}
            openPopup={openPopup}
            success={success}
            setSuccess={setSuccess}
          />
        )}
        {bookingWindowPopup.emergency && (
          <ManageBookingWindowEmergency
            onBackdropClick={onBackdropClick}
            bookingWindow={bookingWindow}
            success={success}
            setSuccess={setSuccess}
            openPopup={openPopup}
          />
        )}
      </div>
    </>
  );
};

export default BookingWindow;
