import React from "react";
import BatterySize from "./BatterySize";
import BookingTime from "./BookingTime";
import BookingWindow from "./BookingWindow";
import { useState, useEffect } from "react";
import { pageTitles } from "../../../configuration/GlobalConfig";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import responseHandler from "../../../services/responseHandler";
import { messages } from "../../../configuration/GlobalConfig";
import NoPriviliges from "../../UI/NoPriviliges";
import useAuth from "../../../hooks/useAuth";
const General = () => {
  const axiosPrivate = useAxiosIntercept();
  const { auth } = useAuth();
  const [bookingProfile, setBookingProfile] = useState({});
  const [error, setError] = useState("");
  const [success, setSuccess] = useState(false);
  const [hideSettings, setHideSettings] = useState({ booking_time: true, booking_window: true, battery_size: true });
  const handleHideSettings = (type) => {
    let currentData = { ...hideSettings };
    currentData[type] = !currentData[type];
    setHideSettings(currentData);
  };
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    let response = {};
    const getAttendantIncentive = async () => {
      let URL = process.env.REACT_APP_GET_ATTENDANT_INCENTIVE;
      const request = {
        config_data: [
          {
            site: "admin",
            module: "settings",
            config_key: "booking_time",
          },
        ],
      };
      try {
        const { data } = await axiosPrivate.post(URL, request);

        if (data?.status === 200 && isMounted) {
          response = responseHandler(data, "API_SUCCESS");

          let json_value = response?.response?.data[0].value;
          let jsonObj = JSON.parse(json_value);


          setBookingProfile(jsonObj);
        } else {
          response = responseHandler(data, "API_ERROR");
          //Handler Error Here...
          setError(messages.API_ERROR);
        }
      } catch (err) {
        response = responseHandler(err, "NETWORK_ERROR");
        //Handler Error Here...
        setError(messages.NETWORK_ERROR);
      }
    };

    isMounted && getAttendantIncentive();

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [success]);
  document.title = pageTitles.GENERAL;
  return (
    auth.priviliges.includes("read_settings") ?
      <div class="yRow mt-24 rowLists">
        <BookingTime
          bookingProfile={bookingProfile}
          success={success}
          setSuccess={setSuccess}
          setBookingProfile={setBookingProfile}
          hideSettings={hideSettings}
          handleHideSettings={handleHideSettings}
        />
        <BookingWindow bookingProfile={bookingProfile}
          hideSettings={hideSettings}
          handleHideSettings={handleHideSettings}
        />
        <BatterySize
          hideSettings={hideSettings}
          handleHideSettings={handleHideSettings}
        />
      </div>
      : <NoPriviliges />
  );
};

export default General;
