import React from "react";
import { useState } from "react";
import Overlay from "../../../utils/Overlay";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Success from "../../UI/Success";
import Error from "../../UI/Error";

const ManageBatterySize = ({
  batterySize,
  onBackdropClick,
  closePopup,
  setBatterySize,
  success,
  setSuccess,
}) => {
  const [Operator, setOperator] = useState("");
  const [isEdit, setIsEdit] = useState("");
  const [isDelete, setIsDelete] = useState("");
  const axiosPrivate = useAxiosIntercept();
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [maxUnit, setMaxUnit] = useState("");
  const [minUnit, setMinUnit] = useState("");
  const [lessCheckedIcon, setLessCheckedIcon] = useState("");
  const [greaterCheckedIcon, setGreaterCheckedIcon] = useState("");
  const [index, setIndex] = useState("");
  const [error, setError] = useState({
    minError: "",
    maxError: "",
    emptyError: "",
  });
  const [fields, setFields] = useState([
    {
      key: Date.now(),
      operator: "",
      data: {
        maximum_battery_unit: "",
        minimum_battery_unit: "",
      },
    },
  ]);
  batterySize.map((size) => {
    const key = Math.random();

    size.key = key;
  });

  const handelClose = () => {
    setMaxUnit("");
    setMinUnit("");
    setLessCheckedIcon("");
    setGreaterCheckedIcon("");
    onBackdropClick();
    setIsEdit(false);
  };
  const deleteSize = (e, i, id) => {
    setIsDelete(true);
    const filtered = batterySize.filter((obj) => {
      return obj.key !== id;
    });
    setBatterySize(filtered);
  };
  const edit = (e, operator, key, maxsize, minsize, i) => {
    setIsEdit(true);
    if (operator == ">") {
      setMaxUnit(minsize);
    } else if (operator == "<") {
      setMinUnit(maxsize);
    } else if (operator == "-") {
      setMinUnit(minsize);
      setMaxUnit(maxsize);
    }
    setIndex(i);
    if (operator === ">") {
      setGreaterCheckedIcon(true);
      setLessCheckedIcon(false);
    } else if (operator === "<") {
      setLessCheckedIcon(true);
      setGreaterCheckedIcon(false);
    } else if (operator === "-") {
      setGreaterCheckedIcon(true);
      setLessCheckedIcon(true);
    }
    const values = [...batterySize];
  };

  const handelMinSize = (e) => {
    const values = [...batterySize];
    setMinUnit(e.target.value);
    if (greaterCheckedIcon === true && lessCheckedIcon === true) {
      setOperator("-");
      values[index].data["minimum_battery_unit"] = e.target.value;
    } else if (greaterCheckedIcon === true) {
      setOperator(">");
      values[index].data["minimum_battery_unit"] = e.target.value;
      values[index].data["maximum_battery_unit"] = 10000;
    } else if (lessCheckedIcon === true) {
      setOperator("<");
      values[index].data["maximum_battery_unit"] = e.target.value;
      values[index].data["minimum_battery_unit"] = 0;
    }

    values[index]["operator"] = Operator;
    setBatterySize(values);
  };
  const handelMaxSize = (e) => {
    const values = [...batterySize];
    setMaxUnit(e.target.value);
    if (greaterCheckedIcon === true && lessCheckedIcon === true) {
      setOperator("-");
      values[index].data["maximum_battery_unit"] = e.target.value;
    } else if (greaterCheckedIcon === true) {
      setOperator(">");

      values[index].data["minimum_battery_unit"] = e.target.value;
      values[index].data["maximum_battery_unit"] = 10000;
    } else if (lessCheckedIcon === true) {
      setOperator("<");
      values[index].data["minimum_battery_unit"] = 0;
      values[index].data["maximum_battery_unit"] = e.target.value;
    }

    values[index]["operator"] = Operator;
    setBatterySize(values);
  };

  const handelLessCheckedIcon = (e, i) => {
    setLessCheckedIcon("");
    setLessCheckedIcon(!lessCheckedIcon);
    setOperator("<");
    const values = [...batterySize];
    values[index].data["maximum_battery_unit"] = maxUnit;
    setBatterySize(values);
    setMinUnit("");
    setMaxUnit("");
    setError({
      minError: "",
      emptyError: "",
    });
  };
  const handelGreaterCheckedIcon = (e, i) => {
    setGreaterCheckedIcon("");
    setGreaterCheckedIcon(!greaterCheckedIcon);
    setOperator(">");
    const values = [...batterySize];
    values[index].data["minimum_battery_unit"] = minUnit;
    setBatterySize(values);
    setMaxUnit("");
    setMinUnit("");
    setError({
      maxError: "",
      emptyError: "",
    });
  };
  const newArray = batterySize;
  let isError = false;

  const submit = async () => {

    if (
      isDelete == false &&
      lessCheckedIcon == false &&
      greaterCheckedIcon == false &&
      minUnit == "" &&
      maxUnit == ""
    ) {
      isError = true;
      setError((prev) => {
        return {
          ...prev,
          emptyError: "Please select atleast one field",
        };
      });
    }
    if (lessCheckedIcon == true && minUnit == "") {
      isError = true;
      setError((prev) => {
        return {
          ...prev,
          minError: "Please select minimum size",
        };
      });
    }
    if (greaterCheckedIcon == true && maxUnit == "") {
      isError = true;
      setError((prev) => {
        return {
          ...prev,
          maxError: "Please select maximum size",
        };
      });
    }
    if (!isError) {
      const request = {
        config_data: {
          site: "admin",
          module: "settings",
          config_key: "battery_type",
          value: newArray,
        },
      };
      const url = process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
      const response = await axiosPrivate.post(url, request);
      setSuccessMessage("");
      if (response?.data?.status === 200) {
        setErrorMessage("");
        setSuccessMessage(response?.data?.message);
        setTimeout(() => {
          setMinUnit("");
          setMaxUnit("");
          setIsEdit(false);
          setSuccessMessage("");
          setErrorMessage("");
          onBackdropClick(true);
          setSuccess(!success);
        }, 3000);
      } else {
        setErrorMessage(response?.data?.message);
      }

    }
  };

  return (
    closePopup && (
      <Overlay>
        <div
          class="model_box_child manageBookingTimeP BatterySize"
          id="manageBookingTimeP_BatterySize"
          style={{ width: "500px" }}
        >
          <div class="ap_heading">
            <h4>
              Manage booking time{" "}
              <span
                class="material-symbols-rounded black close_model"
                onClick={handelClose}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section>
              <div class="timesList dForm">
                <ul>
                  {batterySize ? (
                    batterySize.map((sizes, index) => {
                      const { operator, data } = sizes;
                      return operator === "<" ? (
                        <li>
                          <span>
                            {" "}
                            {`${operator}${data.maximum_battery_unit} kWh`}
                          </span>
                          <div class="icons">
                            <i
                              class="material-symbols-rounded mt-m"
                              onClick={(e) =>
                                edit(
                                  e,
                                  sizes.operator,
                                  sizes.key,
                                  data.maximum_battery_unit,
                                  data.minimum_battery_unit,
                                  index
                                )
                              }
                            >
                              edit
                            </i>
                            <i
                              class="material-symbols-rounded mt-m"
                              onClick={(e) => deleteSize(e, index, sizes.key)}
                            >
                              delete
                            </i>
                          </div>
                        </li>
                      ) : operator === "-" ? (
                        <li>
                          <span>{`${data.minimum_battery_unit}${operator}${data.maximum_battery_unit} kWh`}</span>
                          <div class="icons">
                            <i
                              class="material-symbols-rounded mt-m"
                              onClick={(e) =>
                                edit(
                                  e,
                                  sizes.operator,
                                  sizes.key,
                                  data.maximum_battery_unit,
                                  data.minimum_battery_unit,
                                  index
                                )
                              }
                            >
                              edit
                            </i>
                            <i
                              class="material-symbols-rounded mt-m"
                              onClick={(e) => deleteSize(e, index, sizes.key)}
                            >
                              delete
                            </i>
                          </div>
                        </li>
                      ) : (
                        <li>
                          <span>{`${operator}${data.minimum_battery_unit} kWh`}</span>
                          <div class="icons">
                            <i
                              class="material-symbols-rounded mt-m"
                              onClick={(e) =>
                                edit(
                                  e,
                                  sizes.operator,
                                  sizes.key,
                                  data.maximum_battery_unit,
                                  data.minimum_battery_unit,
                                  index
                                )
                              }
                            >
                              edit
                            </i>
                            <i
                              class="material-symbols-rounded mt-m"
                              onClick={(e) => deleteSize(e, index, sizes.key)}
                            >
                              delete
                            </i>
                          </div>
                        </li>
                      );
                    })
                  ) : (
                    <></>
                  )}
                </ul>

                {isEdit &&
                  fields.map((field) => {
                    return (
                      <div class="">
                        <div class="xType alignBottom mt-16">
                          <div class="fieldGroup mt-0">
                            <>
                              <em class="smallLabel">
                                <i
                                  class="material-symbols-rounded activeFill mr-8"
                                  id="lessThan"
                                  onClick={(e) => handelLessCheckedIcon(e)}
                                >
                                  {lessCheckedIcon === true
                                    ? "check_circle"
                                    : "radio_button_unchecked"}
                                </i>{" "}
                                Less than/Minimum
                              </em>
                              <div class="multiOption">
                                <input
                                  type="text"
                                  placeholder="Enter battery size"
                                  name="minSize"
                                  value={minUnit}
                                  onChange={(e) => handelMinSize(e)}
                                  disabled={
                                    lessCheckedIcon === true ? false : true
                                  }
                                />
                                <div class="sepText bg">
                                  <span>kWH</span>
                                </div>
                              </div>
                            </>
                            {error.minError && <Error error={error.minError} />}
                          </div>

                          <div class="fieldGroup mt-0">
                            <>
                              <em class="smallLabel">
                                <i
                                  class="material-symbols-rounded activeFill  mr-8"
                                  id="greaterThan"
                                  onClick={(e) => handelGreaterCheckedIcon(e)}
                                >
                                  {greaterCheckedIcon === true
                                    ? "check_circle"
                                    : "radio_button_unchecked"}
                                </i>
                                Greater than/Maximum
                              </em>
                              <div class="multiOption">
                                <input
                                  type="text"
                                  placeholder="Enter battery size"
                                  name="maxSize"
                                  value={maxUnit}
                                  onChange={(e) => handelMaxSize(e)}
                                  disabled={
                                    greaterCheckedIcon === true ? false : true
                                  }
                                />
                                <div class="sepText bg">
                                  <span>kWH</span>
                                </div>
                              </div>
                            </>
                            {error.maxError && <Error error={error.maxError} />}
                          </div>
                        </div>

                        {error.emptyError && <Error error={error.emptyError} />}
                      </div>
                    );
                  })}
              </div>
            </section>

            <div class="actionButtons mt-24">
              <span>
                <a
                  href="javascript:void(0);"
                  class="btn prim fullW"
                  onClick={submit}
                >
                  Save
                </a>
              </span>
            </div>
            {successMessage ? <Success success={successMessage} /> : <></>}
            {errorMessage ? <Error error={errorMessage} /> : <></>}
          </div>
        </div>
      </Overlay>
    )
  );
};

export default ManageBatterySize;
