import axios from "axios";
import React from "react";
import { useState } from "react";
import Overlay from "../../../utils/Overlay";
import { SettingTime } from "../SettingTime";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import moment from "moment";
import Success from "../../UI/Success";
import Error from "../../UI/Error";
import { useRef } from "react";
import { useEffect } from "react";

const ManageBookingTime = ({
  bookingProfile,
  value,
  onBackdropClick,
  openPopup,
  success,
  setSuccess,
}) => {

  const maxTimeRef = useRef();
  const minTimeRef = useRef();
  const axiosPrivate = useAxiosIntercept();
  const [isEdit, setIsEdit] = useState(false);
  const [amPm, setAmPm] = useState("");
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");

  const bookingKey = value === "customers" ? "direct_customers" : "partners";

  const handelAmPm = (e) => {
    setAmPm(e.currentTarget.id);
    setShowDropDown({ from: false, to: false });
  };
  const [fromTimeAmPm, setFromTimeAmPm] = useState(false);
  const [toTimeAmPm, setToTimeAmPm] = useState(false);
  const [showDropDown, setShowDropDown] = useState({
    from: false,
    to: false,
  });
  const handelClose = () => {
    setIsEdit(false);
    setFromtime("");
    setTotime("");
    setFromTimeAmPm("");
    setToTimeAmPm("");
    setErrorMessage("");
    onBackdropClick();
  };

  const handelDropDown = (e) => {
    if (e.currentTarget.id !== undefined) {
      setShowDropDown({
        [e.currentTarget.id]: !showDropDown[e.currentTarget.id],
      });
    } else {
      setShowDropDown({ from: false });
      setShowDropDown({ to: false });
    }
  };
  useEffect(() => {
    const handleClickOutside = (event) => {
      if (
        maxTimeRef.current &&
        !maxTimeRef.current.contains(event.target) &&
        (minTimeRef.current === undefined ||
          (minTimeRef.current && !minTimeRef.current.contains(event.target)))
      ) {
        handelDropDown(event);
      }
    };
    document.addEventListener("click", handleClickOutside, true);
    return () => {
      document.removeEventListener("click", handleClickOutside, true);
    };
  }, []);
  const handelFromTImeAmPm = (e, i) => {
    setFromTimeAmPm(e.currentTarget.id);
    setShowDropDown({ from: false, to: false });
    // const values = [...fields];
  };
  const handelToTimeAmPm = (e, i) => {

    setToTimeAmPm(e.currentTarget.id);
    setShowDropDown({ from: false, to: false });
    //const values = [...fields];
  };
  const fromTime =
    bookingProfile?.[bookingKey]?.data[0]?.package_operating_start_time;
  const toTime =
    bookingProfile?.[bookingKey]?.data[0]?.package_operating_end_time;
  const [fromtime, setFromtime] = useState("");

  const [totime, setTotime] = useState("");
  const handelFromTime = (e, id) => {
    setFromtime(id);
    setShowDropDown({ from: false });
  };
  const handelToTime = (e, id) => {
    setTotime(id);
    setShowDropDown({ to: false });
  };
  const edit = (e) => {
    setIsEdit(true);
    setErrorMessage("");
    const fromTimeArray = SettingTime(fromTime).split(":");

    const toTimeArray = SettingTime(toTime).split(":");
    const fromAmPm = fromTimeArray[1].substring(2, 4);
    const toAmPm = toTimeArray[1].substring(2, 4);
    fromAmPm === "am" ? setFromTimeAmPm("am") : setFromTimeAmPm("pm");
    toAmPm === "am" ? setToTimeAmPm("am") : setToTimeAmPm("pm");
    setFromtime(SettingTime(fromTime));
    setTotime(SettingTime(toTime));
  };
  const fields = {
    ...bookingProfile,
  };

  const submit = async () => {
    if (fromtime == "" || totime == "" || fromTimeAmPm == "" || fromTimeAmPm === false || toTimeAmPm == "" || toTimeAmPm === false) {
      setErrorMessage("Nothing to update");
      return;
    }
    const finalobject = {
      ...fields,
      [bookingKey]: {
        data: [
          {
            package_operating_start_time: moment(
              `${fromtime} ${fromTimeAmPm}`,
              "hh:mm A"
            ).format("HH:mm:ss"),
            package_operating_end_time: moment(
              `${totime} ${toTimeAmPm}`,
              "hh:mm A"
            ).format("HH:mm:ss"),
          },
        ],
      },
    };
    const request = {
      config_data: {
        site: "admin",
        module: "settings",
        config_key: "booking_time",
        value: finalobject,
      },
    };
    const url = process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
    const response = await axiosPrivate.post(url, request);
    if (response?.data?.status === 200) {
      setSuccessMessage("");
      setErrorMessage("");
      setTimeout(() => {
        onBackdropClick(true);
        setFromTimeAmPm("");
        setToTimeAmPm("");
        setTotime("");
        setFromtime("");
        setIsEdit(false);
        setErrorMessage("");
        setSuccessMessage("");
        setSuccess(!success);
      }, 3000);
      setSuccessMessage("Data updated successfully");
    } else {
      setSuccessMessage("");
      setErrorMessage("");
      setErrorMessage(response?.data?.message);
    }
  };
  return (
    openPopup && (
      <Overlay>
        <div
          class="model_box_child manageBookingTimeP Corporate"
          id="manageBookingTimeP_Corporate"
          style={{ width: "360px" }}
        >
          <div class="ap_heading">
            <h4>
              Manage booking time{" "}
              <span
                onClick={handelClose}
                class="material-symbols-rounded black close_model"
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP">
              <div class="promoText customer">
                <h4>
                  {value === "customers" ? "Direct Customers" : "Partners"}
                </h4>
                <p>1 booking time slot</p>
              </div>
              <div class="timesList">
                <ul>
                  <li>
                    <span>
                      {bookingProfile?.[bookingKey]?.data[0]
                        ? SettingTime(
                          bookingProfile?.[bookingKey]?.data[0]
                            ?.package_operating_start_time
                        ) +
                        " - " +
                        SettingTime(
                          bookingProfile?.[bookingKey]?.data[0]
                            ?.package_operating_end_time
                        )
                        : null}
                    </span>
                    <div class="icons">
                      <i
                        class="material-symbols-rounded mt-m"
                        onClick={(e) => edit(e)}
                      >
                        edit
                      </i>
                      <i class="material-symbols-rounded mt-m disable">delete</i>
                    </div>
                  </li>
                  {/* <li>
                  <span>11pm - 7am</span>
                  <div class="icons">
                    <i class="material-symbols-rounded mt-m">edit</i>
                    <i class="material-symbols-rounded mt-m">delete</i>
                  </div>
                </li> */}
                </ul>
              </div>
              {isEdit ? (
                <div class="addTime dForm">
                  <div class="lists">
                    <div class="xType alignBottom">
                      <div class="fieldGroup">
                        <em class="smallLabel">Minimum time</em>
                        <span class="">
                          <div class="multiOption">
                            <div
                              ref={minTimeRef}
                              id="from"
                              onClick={(e) => handelDropDown(e)}
                              class={
                                showDropDown.from
                                  ? "selectBox open"
                                  : "selectBox"
                              }
                            >
                              <p class="selected">
                                {isEdit &&
                                  fromtime &&
                                  typeof fromtime === "string" &&
                                  fromtime.includes(":")
                                  ? fromtime.split(":")[0]
                                  : isEdit && fromtime
                                    ? fromtime
                                    : "Select time"}
                                <i class="material-symbols-rounded grey">
                                  expand_more
                                </i>
                              </p>
                              <div class="selectDrop customScroll hFix">
                                <ul class="dropMenu">
                                  {Array.apply(null, Array(parseInt(12))).map(
                                    function (x, i) {
                                      return (
                                        <li
                                          class={
                                            fromtime === i + 1 ? "selected" : ""
                                          }
                                        >
                                          <a
                                            href="javascript:void(0);"
                                            id={i + 1}
                                            onClick={(e) =>
                                              handelFromTime(e, i + 1)
                                            }
                                          >
                                            {i + 1}
                                            {fromtime === i + 1 ? (
                                              <i class="material-symbols-rounded">
                                                done
                                              </i>
                                            ) : (
                                              ""
                                            )}
                                          </a>
                                        </li>
                                      );
                                    }
                                  )}
                                </ul>
                              </div>
                            </div>
                            <div class="sepText">
                              <span
                                id="am"
                                onClick={(e) => handelFromTImeAmPm(e)}
                                class={fromTimeAmPm === "am" ? "active" : ""}
                              >
                                am
                              </span>
                              <span
                                id="pm"
                                onClick={(e) => handelFromTImeAmPm(e)}
                                class={fromTimeAmPm === "pm" ? "active" : ""}
                              >
                                pm
                              </span>
                            </div>
                          </div>
                        </span>
                      </div>
                      <div class="fieldGroup">
                        <em class="smallLabel">Maximum time</em>
                        <span>
                          <div class="multiOption">
                            <div
                              ref={maxTimeRef}
                              id="to"
                              onClick={(e) => handelDropDown(e)}
                              class={
                                showDropDown.to ? "selectBox open" : "selectBox"
                              }
                            >
                              <p class="selected">
                                {isEdit &&
                                  totime &&
                                  typeof totime === "string" &&
                                  totime.includes(":")
                                  ? totime.split(":")[0]
                                  : isEdit && totime
                                    ? totime
                                    : "Select time"}
                                <i class="material-symbols-rounded grey">
                                  expand_more
                                </i>
                              </p>
                              <div class="selectDrop customScroll hFix">
                                <ul class="dropMenu">
                                  {Array.apply(null, Array(parseInt(12))).map(
                                    function (x, i) {
                                      return (
                                        <li
                                          class={
                                            totime === i + 1 ? "selected" : ""
                                          }
                                        >
                                          <a
                                            href="javascript:void(0);"
                                            id={i + 1}
                                            onClick={(e) =>
                                              handelToTime(e, i + 1)
                                            }
                                          >
                                            {i + 1}
                                            {toTime === i + 1 ? (
                                              <i class="material-symbols-rounded">
                                                done
                                              </i>
                                            ) : (
                                              ""
                                            )}
                                          </a>
                                        </li>
                                      );
                                    }
                                  )}
                                </ul>
                              </div>
                            </div>
                            <div class="sepText">
                              <span
                                id="am"
                                onClick={(e) => handelToTimeAmPm(e)}
                                class={toTimeAmPm === "am" ? "active" : ""}
                              >
                                am
                              </span>
                              <span
                                id="pm"
                                onClick={(e) => handelToTimeAmPm(e)}
                                class={toTimeAmPm === "pm" ? "active" : ""}
                              >
                                pm
                              </span>
                            </div>
                          </div>
                        </span>
                      </div>
                      {/*<div class="fieldGroup">
                        <i class="material-symbols-rounded mt-m">delete</i>
                      </div>*/}
                    </div>
                  </div>
                  {/* <div class="link">
                  <i class="material-symbols-rounded mt-m">more_time</i>
                  <a href="javascript:void(0);">Add new booking time</a>
                </div> */}
                </div>
              ) : null}
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a
                  href="javascript:void(0);"
                  class="btn prim fullW"
                  onClick={submit}
                >
                  Save
                </a>
              </span>
            </div>
            {successMessage && <Success success={successMessage} />}
            {errorMessage && <Error error={errorMessage} />}
          </div>
        </div>
      </Overlay>
    )
  );
};

export default ManageBookingTime;
