import React from "react";
import { useState } from "react";
import Overlay from "../../../utils/Overlay";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Success from "../../UI/Success";
import Error from "../../UI/Error";
import moment from "moment";
import { useRef } from "react";
import { useEffect } from "react";
import { SettingTime } from "../SettingTime";

const ManageBookingTimeEmergency = ({
  bookingProfile,
  success,
  setSuccess,
  onBackdropClick,
  openPopup,
}) => {

  const [type, setType] = useState("");
  const [amPm, setAmPm] = useState("");
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [fromTimeAmPm, setFromTimeAmPm] = useState(false);
  const [toTimeAmPm, setToTimeAmPm] = useState(false);
  const [fromtime, setFromtime] = useState("");
  const [isCustome, setIsCustome] = useState(false);
  const [totime, setTotime] = useState("");
  const [error, setError] = useState({
    toTimeError: "",
    fromTimeError: "",
  });
  const fromTime =
    bookingProfile?.emergency?.data[0]?.package_operating_start_time;
  const toTime = bookingProfile?.emergency?.data[0]?.package_operating_end_time;
  const axiosPrivate = useAxiosIntercept();
  useEffect(() => {
    if (bookingProfile?.emergency?.data[0]?.package_operating_start_time) {


      const fromTimeArray = SettingTime(fromTime).split(":");
      const toTimeArray = SettingTime(toTime).split(":");
      const fromAmPm = fromTimeArray[1].substring(2, 4);
      const toAmPm = toTimeArray[1].substring(2, 4);
      fromAmPm === "am" ? setFromTimeAmPm("am") : setFromTimeAmPm("pm");
      toAmPm === "am" ? setToTimeAmPm("am") : setToTimeAmPm("pm");
      setFromtime(SettingTime(fromTime));
      setTotime(SettingTime(toTime));
      setIsCustome(true);
    }
  }, [bookingProfile?.emergency?.data[0]?.package_operating_start_time]);
  const [checked, setChecked] = useState({
    hours: false,
    customTime: false,
  });
  const minTimeRef = useRef();
  const maxTimeRef = useRef();
  const handelFromTime = (e, id) => {
    setFromtime(id);
    setShowDropDown({ from: false });
    setError((previousData) => ({
      ...previousData,
      fromTimeError: "",
    }));
  };
  const [showDropDown, setShowDropDown] = useState({
    from: false,
    to: false,
  });

  const handelClose = () => {
    bookingProfile?.emergency?.data[0]?.package_operating_start_time
      ? setIsCustome(true)
      : setIsCustome(false);
    onBackdropClick();
  };

  const handelDropDown = (e) => {
    if (e.currentTarget.id !== undefined) {
      setShowDropDown({
        [e.currentTarget.id]: !showDropDown[e.currentTarget.id],
      });
    } else {
      setShowDropDown({ from: false });
      setShowDropDown({ to: false });
    }
  };
  useEffect(() => {
    const handleClickOutside = (event) => {
      if (
        maxTimeRef.current &&
        !maxTimeRef.current.contains(event.target) &&
        (minTimeRef.current === undefined ||
          (minTimeRef.current && !minTimeRef.current.contains(event.target)))
      ) {
        handelDropDown(event);
      }
    };
    document.addEventListener("click", handleClickOutside, true);
    return () => {
      document.removeEventListener("click", handleClickOutside, true);
    };
  }, []);

  const handelToTime = (e, id) => {
    setTotime(id);
    setShowDropDown({ to: false });
    setError((previousData) => ({
      ...previousData,
      toTimeError: "",
    }));
  };
  const handelFromTImeAmPm = (e, i) => {
    setFromTimeAmPm(e.currentTarget.id);
    setShowDropDown({ from: false, to: false });
    // const values = [...fields];
    setError((previousData) => ({
      ...previousData,
      fromTimeError: "",
    }));
  };
  const handelToTimeAmPm = (e, i) => {

    setToTimeAmPm(e.currentTarget.id);
    setShowDropDown({ from: false, to: false });
    //const values = [...fields];
    setError((previousData) => ({
      ...previousData,
      toTimeError: "",
    }));
  };
  const handelType = (e) => {
    if (e.currentTarget.id == "hours") {
      setIsCustome(false);
    } else {
      setIsCustome(true);
    }

    setType(e.currentTarget.id);
    setChecked({ [e.currentTarget.id]: true });
    setError({
      toTimeError: "",
      fromTimeError: "",
    });
    setErrorMessage("");
  };
  const fields = {
    ...bookingProfile,
  };

  const submit = async () => {
    var customRequest;
    var hourRequest;
    let isError = false;
    if ((isCustome && totime == "") || (isCustome && toTimeAmPm == "")) {

      isError = true;
      setError((prev) => ({
        ...prev,
        toTimeError: "Please select both time and am/pm",
      }));
    }
    if ((isCustome && fromtime == "") || (isCustome && fromTimeAmPm == "")) {

      isError = true;
      setError((prev) => ({
        ...prev,
        fromTimeError: "Please select both time and am/pm",
      }));
    }
    if (!isError) {



      if (isCustome) {

        const finalobject = {
          ...fields,
          emergency: {
            data: [
              {
                package_operating_start_time: moment(
                  `${fromtime} ${fromTimeAmPm}`,
                  "hh:mm A"
                ).format("HH:mm:ss"),
                package_operating_end_time: moment(
                  `${totime} ${toTimeAmPm}`,
                  "hh:mm A"
                ).format("HH:mm:ss"),
              },
            ],
          },
        };

        var customRequest = {
          config_data: {
            site: "admin",
            module: "settings",
            config_key: "booking_time",
            value: finalobject,
          },
        };
      } else {
        const finalobject = {
          ...fields,
          emergency: {
            data: [
              {
                value: 24,
                unit: "H",
              },
            ],
          },
        };
        var hourRequest = {
          config_data: {
            site: "admin",
            module: "settings",
            config_key: "booking_time",
            value: finalobject,
          },
        };
      }

      const url = process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
      const response = await axiosPrivate.post(
        url,
        type === "hours" ? hourRequest : customRequest
      );
      if (response?.data?.status === 200) {
        setSuccessMessage("");
        setErrorMessage("");
        setTimeout(() => {
          onBackdropClick(true);
          setFromTimeAmPm("");
          setToTimeAmPm("");
          setTotime("");
          setFromtime("");
          setChecked({});
          setErrorMessage("");
          setSuccessMessage("");
          setSuccess(!success);
        }, 3000);
        setSuccessMessage("Data updated successfully");
      } else {
        setSuccessMessage("");
        setErrorMessage("");
        setErrorMessage(response?.data?.message);
      }
    }
  };
  return (
    openPopup && (
      <Overlay>
        <div
          class="model_box_child"
          id="manageBookingTimeP_Emergency4"
          style={{ width: "500px" }}
        >
          <div class="ap_heading">
            <h4>
              Manage booking time
              <span
                class="material-symbols-rounded black close_model"
                onClick={handelClose}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP">
              <div class="promoText customer">
                <h4>Emergency</h4>
              </div>

              <div class="addTime dForm">
                <div class="fieldGroup mr-0">
                  <ul class="yType">
                    <li onClick={(e) => handelType(e)} id="hours">
                      <input
                        checked={isCustome == false && "checked"}
                        name="hours"
                        type="radio"
                      />
                      <label for="yTypeRadio1">24 hours</label>
                    </li>
                    <li onClick={(e) => handelType(e)} id="customTime">
                      <input
                        checked={isCustome === true && "checked"}
                        name="customeTime"
                        type="radio"
                      />
                      <label for="yTypeRadio1">Custom time</label>
                    </li>
                  </ul>
                </div>

                <div class="lists ml-24 mt-16">
                  <div class="xType alignBottom">
                    {isCustome && (
                      <>
                        <div class="fieldGroup">
                          {/*<em class="smallLabel">Minimum time</em>*/}
                          <span class="">
                            <div class="multiOption">
                              <div
                                ref={minTimeRef}
                                id="from"
                                onClick={(e) => handelDropDown(e)}
                                class={
                                  showDropDown.from
                                    ? "selectBox open"
                                    : "selectBox"
                                }
                              >
                                <p class="selected">
                                  {fromtime &&
                                    typeof fromtime === "string" &&
                                    totime.includes(":")
                                    ? fromtime.split(":")[0]
                                    : fromtime
                                      ? fromtime
                                      : "Select time"}
                                  <i class="material-symbols-rounded grey">
                                    expand_more
                                  </i>
                                </p>
                                <div class="selectDrop customScroll hFix">
                                  <ul class="dropMenu">
                                    {Array.apply(null, Array(parseInt(12))).map(
                                      function (x, i) {
                                        return (
                                          <li
                                            class={
                                              fromtime === i + 1
                                                ? "selected"
                                                : ""
                                            }
                                          >
                                            <a
                                              href="javascript:void(0);"
                                              id={i + 1}
                                              onClick={(e) =>
                                                handelFromTime(e, i + 1)
                                              }
                                            >
                                              {i + 1}
                                              {fromtime === i + 1 ? (
                                                <i class="material-symbols-rounded">
                                                  done
                                                </i>
                                              ) : (
                                                ""
                                              )}
                                            </a>
                                          </li>
                                        );
                                      }
                                    )}
                                  </ul>
                                </div>
                              </div>
                              <div class="sepText">
                                <span
                                  id="am"
                                  onClick={(e) => handelFromTImeAmPm(e)}
                                  class={fromTimeAmPm === "am" ? "active" : ""}
                                >
                                  am
                                </span>
                                <span
                                  id="pm"
                                  onClick={(e) => handelFromTImeAmPm(e)}
                                  class={fromTimeAmPm === "pm" ? "active" : ""}
                                >
                                  pm
                                </span>
                              </div>
                            </div>
                          </span>
                          {/* {(fromtime === "" && error.fromTimeError !== "") ||
                          (fromTimeAmPm === "" &&
                            error.fromTimeError !== "") ? ( */}
                          <Error error={error.fromTimeError} />
                          {/* ) : (
                            ""
                          )} */}
                        </div>
                        <div class="fieldGroup">
                          {/*<em class="smallLabel">Maximum time</em>*/}
                          <span>
                            <div class="multiOption">
                              <div
                                ref={maxTimeRef}
                                id="to"
                                onClick={(e) => handelDropDown(e)}
                                class={
                                  showDropDown.to
                                    ? "selectBox open"
                                    : "selectBox"
                                }
                              >
                                <p class="selected">
                                  {totime &&
                                    typeof totime === "string" &&
                                    totime.includes(":")
                                    ? totime.split(":")[0]
                                    : totime
                                      ? totime
                                      : "Select time"}
                                  <i class="material-symbols-rounded grey">
                                    expand_more
                                  </i>
                                </p>
                                <div class="selectDrop customScroll hFix">
                                  <ul class="dropMenu">
                                    {Array.apply(null, Array(parseInt(12))).map(
                                      function (x, i) {
                                        return (
                                          <li
                                            class={
                                              totime === i + 1 ? "selected" : ""
                                            }
                                          >
                                            <a
                                              href="javascript:void(0);"
                                              id={i + 1}
                                              onClick={(e) =>
                                                handelToTime(e, i + 1)
                                              }
                                            >
                                              {i + 1}
                                              {totime === i + 1 ? (
                                                <i class="material-symbols-rounded">
                                                  done
                                                </i>
                                              ) : (
                                                ""
                                              )}
                                            </a>
                                          </li>
                                        );
                                      }
                                    )}
                                  </ul>
                                </div>
                              </div>
                              <div class="sepText">
                                <span
                                  id="am"
                                  onClick={(e) => handelToTimeAmPm(e)}
                                  class={toTimeAmPm === "am" ? "active" : ""}
                                >
                                  am
                                </span>
                                <span
                                  id="pm"
                                  onClick={(e) => handelToTimeAmPm(e)}
                                  class={toTimeAmPm === "pm" ? "active" : ""}
                                >
                                  pm
                                </span>
                              </div>
                            </div>
                          </span>

                          {/* {(totime === "" && error.toTimeError !== "") ||
                          (toTimeAmPm === "" && error.toTimeError !== "") ? ( */}
                          <Error error={error.toTimeError} />
                          {/* ) : (
                            ""
                          )} */}
                        </div>
                      </>
                    )}
                  </div>
                </div>
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a
                  class="btn prim fullW"
                  href="javascript:void(0);"
                  onClick={submit}
                >
                  Save
                </a>
              </span>
            </div>
            {successMessage && <Success success={successMessage} />}
            {errorMessage && <Error error={errorMessage} />}
          </div>
        </div>
      </Overlay>
    )
  );
};

export default ManageBookingTimeEmergency;
