import React from "react";
import { useState } from "react";
import Overlay from "../../../utils/Overlay";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Success from "../../UI/Success";
import Error from "../../UI/Error";

const ManageBookingWindow = ({
  onBackdropClick,
  bookingWindow,
  success,
  setSuccess,
}) => {
  const minimumTime = bookingWindow?.global?.minimum_time.value;
  const maximumTime = bookingWindow?.global?.maximum_time.value;
  const [errorMessage, setErrorMessage] = useState("");
  const [successMessage, setSuccessMessage] = useState("");
  const axiosPrivate = useAxiosIntercept();
  const [fromTimeAmPm, setFromTimeAmPm] = useState(false);
  const [toTimeAmPm, setToTimeAmPm] = useState(false);
  const [fromtime, setFromtime] = useState("");
  const [totime, setTotime] = useState("");
  const [error, setError] = useState({
    minTimeError: "",
    maxTimeError: "",
    timeError: "",
  });

  const [bookingWindowUnit, setBookingWindowUnit] = useState("");
  const [unitDropdown, setUnitDropdown] = useState({
    minUnit: false,
    maxUnit: false,
  });
  const [maxUnitValue, setMaxUnitValue] = useState(
    bookingWindow?.global?.maximum_time.unit
  );
  const handelMaxUnitValue = (e) => {
    setMaxUnitValue(e.currentTarget.id);
  };
  const handelFilter = (e) => {

    setShowFilter({
      [e.currentTarget.id]: !showFilter[e.currentTarget.id],
    });
  };
  const [showFilter, setShowFilter] = useState({
    maxUnit: false,
    minUnit: false,
  });
  const [minUnitValue, setminUnitValue] = useState(
    bookingWindow?.global?.minimum_time.unit
  );
  const handelminUnitValue = (e) => {
    setminUnitValue(e.currentTarget.id);
  };
  const handelUnit = (e) => {
    setUnitDropdown({ [e.target.id]: !unitDropdown });
  };
  var array = new Array(12);
  const [minTime, setMinTime] = useState(minimumTime);
  const [maxTime, setMaxTime] = useState(maximumTime);
  const [timeValue, setTimeValue] = useState({
    mintime: false,
    maxtime: false,
  });
  const [showDropDown, setShowDropDown] = useState({
    from: false,
    to: false,
  });
  const handelFromTime = (e, id) => {
    setFromtime(id);
    setShowDropDown({ from: false });
  };
  const handelToTime = (e, id) => {
    setTotime(id);
    setShowDropDown({ to: false });
  };
  const handelClose = () => {
    onBackdropClick();
  };
  const handelMinTime = (e, id) => {
    setMinTime(e.target.value);
    setTimeValue({ mintime: false });
  };
  const handelMaxTime = (e, id) => {
    setMaxTime(e.target.value);
    setTimeValue({ maxTime: false });
  };

  const handelTime = (e) => {
    setTimeValue({
      [e.currentTarget.id]: !timeValue[e.currentTarget.id],
    });
  };

  //console.log(finalobject, "ooooooooooooo");
  const update = async () => {

    let errorData = false;
    if (maxTime == "") {
      errorData = true;
      setError((prev) => {
        return { ...prev, maxTimeError: "Maximum time field is required" };
      });
    }
    if (minTime == "") {
      errorData = true;
      setError((prev) => {
        return { ...prev, minTimeError: "Minimum time field is required" };
      });
    }
    if (maxTime < 0 || minTime < 0) {
      errorData = true;
      setError({
        minTimeError: "",
        maxTimeError: "",
        timeError: "Time must be greater than 0",
      });
    }
    if (maxTime !== "" && maxTime > 0 && minTime !== "" && minTime > 0) {
      errorData = false;
      setError({
        minTimeError: "",
        maxTimeError: "",
        timeError: "",
      });
    }
    if (!errorData) {
      setError({
        minTimeError: "",
        maxTimeError: "",
        timeError: "",
      });

      const finalobject = {
        ...bookingWindow,

        global: {
          maximum_time: {
            unit: maxUnitValue,
            value: maxTime,
          },
          minimum_time: {
            unit: minUnitValue,
            value: minTime,
          },
        },
      };
      const finalRequest = {
        config_data: {
          site: "admin",
          module: "settings",
          config_key: "booking_window",
          value: finalobject,
        },
      };


      const url = process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
      const response = await axiosPrivate.post(url, finalRequest);
      if (response?.data?.status === 200) {
        setSuccessMessage("");
        setErrorMessage("");
        setTimeout(() => {
          setMaxTime("");
          onBackdropClick(true);
          setErrorMessage("");
          setSuccessMessage("");
          setSuccess(!success);
        }, 3000);
        setSuccessMessage(response?.data?.message);
      } else {
        setSuccessMessage("");
        setErrorMessage("");
        setErrorMessage(response?.data?.message);
      }

    }
  };

  return (
    <Overlay>
      <div
        class="model_box_child manageBookingTimeP Global"
        id="manageBookingWindowP_Global"
        style={{ width: "460px" }}
      >
        <div class="ap_heading">
          <h4>
            Manage booking window{" "}
            <span
              class="material-symbols-rounded black close_model"
              onClick={handelClose}
            >
              close
            </span>
          </h4>
        </div>
        <div class="contentSection">
          <section class="assignPromoP">
            <div class="promoText customer">
              <h4>Global</h4>
            </div>
            <div class="addTime dForm">
              <div class="lists">
                <div class="xType alignBottom">

                  <div class="fieldGroup">
                    <em class="smallLabel">Minimum time</em>
                    <span>
                      <div class="multiOption">
                        <input
                          class="radiusRightNo borderRightNo"
                          name=""
                          type="number"
                          value={minTime}
                          onChange={(e) => handelMinTime(e)}
                          min="1"
                        ></input>

                        <div
                          onClick={handelFilter}
                          id="minUnit"
                          className={
                            showFilter.minUnit ? "selectBox open" : "selectBox"
                          }
                        >
                          <p className="selected radiusLeftNo">
                            {minUnitValue
                              ? minUnitValue === "H"
                                ? "Hours"
                                : "" || minUnitValue === "M"
                                  ? "Month"
                                  : "" || minUnitValue === "W"
                                    ? "weeks"
                                    : "" || minUnitValue === "D"
                                      ? "Days"
                                      : ""
                              : "Attendant status"}
                            <i className="material-symbols-rounded grey">
                              expand_more
                            </i>
                          </p>
                          <div className="selectDrop customScroll hFix">
                            <ul className="dropMenu">
                              <li
                                className={
                                  minUnitValue === "H" ? "selected" : ""
                                }
                              >
                                <a onClick={handelminUnitValue} id="H">
                                  Hours
                                  {minUnitValue === "H" ? (
                                    <i className="material-symbols-rounded">
                                      done
                                    </i>
                                  ) : (
                                    <></>
                                  )}
                                </a>
                              </li>
                              <li
                                className={
                                  minUnitValue === "M" ? "selected" : ""
                                }
                              >
                                <a onClick={handelminUnitValue} id="M">
                                  Month
                                  {minUnitValue === "M" ? (
                                    <i className="material-symbols-rounded">
                                      done
                                    </i>
                                  ) : (
                                    <></>
                                  )}
                                </a>
                              </li>
                              <li
                                className={
                                  minUnitValue === "W" ? "selected" : ""
                                }
                              >
                                <a onClick={handelminUnitValue} id="W">
                                  Weeks
                                  {minUnitValue === "W" ? (
                                    <i className="material-symbols-rounded">
                                      done
                                    </i>
                                  ) : (
                                    <></>
                                  )}
                                </a>
                              </li>
                              <li
                                className={
                                  minUnitValue === "D" ? "selected" : ""
                                }
                              >
                                <a onClick={handelminUnitValue} id="D">
                                  Days
                                  {minUnitValue === "D" ? (
                                    <i className="material-symbols-rounded">
                                      done
                                    </i>
                                  ) : (
                                    <></>
                                  )}
                                </a>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </span>
                    {minTime == "" && error.minTimeError !== "" && (
                      <Error error={error.minTimeError} />
                    )}

                    {minTime < 0 &&
                      error.minTimeError == "" &&
                      error.timeError !== "" && (
                        <Error error={error.timeError} />
                      )}
                  </div>

                  <div class="fieldGroup">
                    <em class="smallLabel">Maximum time</em>
                    <span>
                      <div class="multiOption">
                        <span class="">
                          <input
                            class="radiusRightNo borderRightNo"
                            name=""
                            type="number"
                            value={maxTime}
                            onChange={(e) => handelMaxTime(e)}
                            min="1"
                          ></input>
                        </span>

                        <div
                          onClick={handelFilter}
                          id="maxUnit"
                          className={
                            showFilter.maxUnit ? "selectBox open" : "selectBox"
                          }
                        >
                          <p className="selected radiusLeftNo">
                            {maxUnitValue
                              ? maxUnitValue === "H"
                                ? "Hours"
                                : "" || maxUnitValue === "M"
                                  ? "Month"
                                  : "" || maxUnitValue === "W"
                                    ? "Weeks"
                                    : "" || maxUnitValue === "D"
                                      ? "Days"
                                      : ""
                              : "Attendant status"}
                            <i className="material-symbols-rounded grey">
                              expand_more
                            </i>
                          </p>
                          <div className="selectDrop customScroll hFix">
                            <ul className="dropMenu">
                              <li
                                className={
                                  maxUnitValue === "H" ? "selected" : ""
                                }
                              >
                                <a onClick={handelMaxUnitValue} id="H">
                                  Hours
                                  {maxUnitValue === "H" ? (
                                    <i className="material-symbols-rounded">
                                      done
                                    </i>
                                  ) : (
                                    <></>
                                  )}
                                </a>
                              </li>
                              <li
                                className={
                                  maxUnitValue === "M" ? "selected" : ""
                                }
                              >
                                <a onClick={handelMaxUnitValue} id="M">
                                  Month
                                  {maxUnitValue === "M" ? (
                                    <i className="material-symbols-rounded">
                                      done
                                    </i>
                                  ) : (
                                    <></>
                                  )}
                                </a>
                              </li>
                              <li
                                className={
                                  maxUnitValue === "W" ? "selected" : ""
                                }
                              >
                                <a onClick={handelMaxUnitValue} id="W">
                                  Weeks
                                  {maxUnitValue === "W" ? (
                                    <i className="material-symbols-rounded">
                                      done
                                    </i>
                                  ) : (
                                    <></>
                                  )}
                                </a>
                              </li>
                              <li
                                className={
                                  maxUnitValue === "D" ? "selected" : ""
                                }
                              >
                                <a onClick={handelMaxUnitValue} id="D">
                                  Days
                                  {maxUnitValue === "D" ? (
                                    <i className="material-symbols-rounded">
                                      done
                                    </i>
                                  ) : (
                                    <></>
                                  )}
                                </a>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </span>

                    {maxTime == "" && error.maxTimeError !== "" && (
                      <Error error={error.maxTimeError} />
                    )}

                    {maxTime < 0 &&
                      error.maxTimeError == "" &&
                      error.timeError !== "" && (
                        <Error error={error.timeError} />
                      )}
                  </div>
                </div>
              </div>
            </div>
          </section>
          <div class="actionButtons mt-24">
            <span>
              <a
                href="javascript:void(0);"
                class="btn prim fullW"
                onClick={update}
              >
                Save
              </a>
            </span>
          </div>
          {successMessage && <Success success={successMessage} />}
          {errorMessage && <Error error={errorMessage} />}
        </div>
      </div>
    </Overlay>
  );
};

export default ManageBookingWindow;
