import React from "react";
import Overlay from "../../../utils/Overlay";
import { useState } from "react";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Success from "../../UI/Success";
import Error from "../../UI/Error";
import useOutsideClick from "../../../hooks/useOutsideClick";
import { useRef } from "react";

const ManageBookingWindowEmergency = ({
  onBackdropClick,
  bookingWindow,
  success,
  setSuccess,
  openPopup,
}) => {

  const [timeValue, setTimeValue] = useState({
    mintime: false,
    maxtime: false,
  });
  const maxTimeRef = useRef();
  const maximumTime = bookingWindow?.emergency?.maximum_time?.value;
  const [minTime, setMinTime] = useState("minimumTime");
  const [maxTime, setMaxTime] = useState(maximumTime);
  const [errorMessage, setErrorMessage] = useState("");
  const [successMessage, setSuccessMessage] = useState("");
  const axiosPrivate = useAxiosIntercept();
  const handelMaxTime = (e, id) => {
    setMaxTime(id);
    setTimeValue({ maxTime: false });
  };
  useOutsideClick(maxTimeRef, (e) => {
    setTimeValue({
      maxTime: false,
    });
  });

  const handelTime = (e) => {
    setTimeValue({
      [e.currentTarget.id]: !timeValue[e.currentTarget.id],
    });
  };
  const handelClose = () => {
    onBackdropClick();
  };
  const submit = async () => {
    bookingWindow.emergency.maximum_time.value = maxTime;
    bookingWindow.emergency.minimum_time.value = maxTime;
    const bookingwindow = {
      ...bookingWindow,
    };

    var finalRequest = {
      config_data: {
        site: "admin",
        module: "settings",
        config_key: "booking_window",
        value: bookingwindow,
      },
    };

    const url = process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
    const response = await axiosPrivate.post(url, finalRequest);
    if (response?.data?.status === 200) {
      setSuccessMessage("");
      setErrorMessage("");
      setTimeout(() => {
        setMaxTime("");
        onBackdropClick(true);
        setErrorMessage("");
        setSuccessMessage("");
        setSuccess(!success);
      }, 3000);
      setSuccessMessage(response?.data?.message);
    } else {
      setSuccessMessage("");
      setErrorMessage("");
      setErrorMessage(response?.data?.message);
    }


  };
  return (
    openPopup && (
      <Overlay>
        <div class="ap_heading">
          <h4>
            Manage booking window
            <span
              class="material-symbols-rounded black close_model"
              onClick={handelClose}
            >
              close
            </span>
          </h4>
        </div>
        <div class="contentSection">
          <section class="assignPromoP">
            <div class="promoText customer">
              <h4>Emergency</h4>
            </div>
            <div class="addTime dForm">
              <div class="lists">
                <div class="xType alignBottom">
                  <div class="fieldGroup">
                    <em class="smallLabel">Select time</em>
                    <span class="">
                      <div class="multiOption">
                        <div
                          ref={maxTimeRef}
                          id="maxtime"
                          onClick={(e) => handelTime(e)}
                          class={
                            timeValue.maxtime ? "selectBox open" : "selectBox"
                          }
                        >
                          <p>
                            {maxTime ? maxTime : "Select time"}
                            <i class="material-symbols-rounded grey">
                              expand_more
                            </i>
                          </p>
                          <div class="selectDrop customScroll hFix">
                            <ul class="dropMenu">
                              {Array.apply(null, Array(parseInt(24))).map(
                                function (x, i) {
                                  return (
                                    <li
                                      class={
                                        maxTime === i + 1 ? "selected" : ""
                                      }
                                    >
                                      <a
                                        href="javascript:void(0);"
                                        id={i + 1}
                                        onClick={(e) => handelMaxTime(e, i + 1)}
                                      >
                                        {i + 1}
                                        {maxTime === i + 1 ? (
                                          <i class="material-symbols-rounded">
                                            done
                                          </i>
                                        ) : (
                                          ""
                                        )}
                                      </a>
                                    </li>
                                  );
                                }
                              )}
                            </ul>
                          </div>
                        </div>
                        <div class="sepText bg">
                          <span class="active">hours</span>
                        </div>
                      </div>
                    </span>
                  </div>
                </div>
              </div>
            </div>
          </section>
          <div class="actionButtons mt-24">
            <span>
              <a
                class="btn prim fullW"
                href="javascript:void(0);"
                onClick={submit}
              >
                Save
              </a>
            </span>
          </div>
          {successMessage && <Success success={successMessage} />}
          {errorMessage && <Error error={errorMessage} />}
        </div>
      </Overlay>
    )
  );
};

export default ManageBookingWindowEmergency;
