import axios from "axios";
import React from "react";
import { useState } from "react";
import Overlay from "../../../utils/Overlay";
import { SettingTime } from "../SettingTime";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Success from "../../UI/Success";
import Error from "../../UI/Error";
import moment from "moment";
import { useRef } from "react";
import { useEffect } from "react";

const ManageCorporateBookingTime = ({
  bookingProfile,
  value,
  onBackdropClick,
  openPopup,
  success,
  setSuccess,
  setBookingProfile,
}) => {
  const maxTimeRef = useRef();
  const minTimeRef = useRef();

  const [fields, setFields] = useState([]);
  bookingProfile.corporate.data.map((corporatedata) => {
    const key = Math.random();

    corporatedata.key = key;
  });
  const add = () => {
    setFields([
      ...fields,
      {
        key: Date.now(),
        package_operating_start_time: "",
        package_operating_end_time: "",
      },
    ]);
  };
  const deleteField = (e, i, id) => {
    let filtered = fields.filter((obj) => {
      return obj.key !== id;
    });
    setFields(filtered);

    let labels_fromtime = [...fromTimeLabel];
    delete labels_fromtime[i];
    setFromTimeLabel(labels_fromtime);

    let labels_totime = [...toTimeLabel];
    delete labels_totime[i];
    setToTimeLabel(labels_totime);

    let current_fromTimeAmPm = { ...fromTimeAmPm };
    delete current_fromTimeAmPm[i];
    setFromTimeAmPm(current_fromTimeAmPm);

    let current_toTimeAmPm = { ...toTimeAmPm };
    delete current_toTimeAmPm[i];
    setToTimeAmPm(current_toTimeAmPm);

  };
  const [pAId, setPAId] = useState("");
  const [showFromDropdown, setShowFromDropdown] = useState(false);
  const [showToDropdown, setShowToDropdown] = useState(false);
  const [updateId, setUpdateId] = useState("");
  const axiosPrivate = useAxiosIntercept();
  const [isEdit, setIsEdit] = useState(false);
  const [Index, setIndex] = useState("");
  const [amPm, setAmPm] = useState({});
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [deleteMode, setDeleteMode] = useState(false);

  const bookingKey = value;

  var time = "";
  const [showDropDown, setShowDropDown] = useState({
    from: false,
    to: false,
  });
  const handelClose = () => {
    onBackdropClick();
    setIsEdit(false);
    setFields([]);
    setFromTimeAmPm([]);
    setTotime([]);
    setFromTimeAmPm([]);
    setToTimeAmPm([]);
    setToTimeLabel([]);
    setFromTimeLabel([]);
  };
  // setIsDelete(true);
  // const filtered = batterySize.filter((obj) => {
  //   return obj.key !== id;
  // });
  //setBatterySize(filtered);

  const handeldelete = async (e, id) => {
    setDeleteMode(true);
    const filtered = bookingProfile?.corporate?.data.filter((obj) => {
      return obj.key !== id;
    });
    let final_filtered_data = { data: filtered };
    // setBookingProfile({
    //   [bookingProfile.corporate.data]: filtered,
    // });
    setBookingProfile((prev) => {
      return {
        ...prev,
        corporate: final_filtered_data,
      };
    });
    setFields([]);
    setFromTimeAmPm([]);
    setTotime([]);
    setFromTimeAmPm([]);
    setToTimeAmPm([]);
    setToTimeLabel([]);
    setFromTimeLabel([]);

  };

  const edit = (e, editIndex) => {
    const fromTime =
      bookingProfile?.[bookingKey].data[editIndex]
        ?.package_operating_start_time;
    const toTime =
      bookingProfile?.[bookingKey].data[editIndex]?.package_operating_end_time;

    const fromTimeArray = SettingTime(fromTime).split(":");
    const toTimeArray = SettingTime(toTime).split(":");
    const fromAmPm = fromTimeArray[1].substring(2, 4);
    const toAmPm = toTimeArray[1].substring(2, 4);

    fromAmPm == "am"
      ? setFromTimeAmPm({ [editIndex]: "am" })
      : setFromTimeAmPm({ [editIndex]: "pm" });
    toAmPm == "am"
      ? setToTimeAmPm({ [editIndex]: "am" })
      : setToTimeAmPm({ [editIndex]: "pm" });
    setIndex(editIndex);
    setIsEdit(true);
    setFromtime(SettingTime(fromTime));
    setTotime(SettingTime(toTime));
    setFields([
      {
        key: Date.now(),
        package_operating_start_time: "",
        package_operating_end_time: "",
      },
    ]);
  };

  const [Fromval, setFromVal] = useState("");
  const [Toval, setToVal] = useState("");
  const [toTimeLabel, setToTimeLabel] = useState([]);
  const [fromTimeLabel, setFromTimeLabel] = useState([]);
  const [fromTimeAmPm, setFromTimeAmPm] = useState([]);
  const [toTimeAmPm, setToTimeAmPm] = useState([]);
  const [fromtime, setFromtime] = useState("");
  const [totime, setTotime] = useState("");
  const [isDelete, setIsDelete] = useState("");

  const handelFromTime = (e, id, key, index) => {
    setFromtime(
      moment(`${id} ${fromTimeAmPm[index]}`, "hh:mm A").format("HH:mm:ss")
    );
    setFromVal(id);
    // const values = fields;
    // values[index]["package_operating_start_time"] = moment(
    //   `${id} ${fromTimeAmPm[index]}`,
    //   "hh:mm A"
    // ).format("HH:mm:ss");
    // values[1]["package_operating_start_time"] = "data";
    // values[index]["package_operating_start_time"] = id;
    setFields((previousData) =>
      previousData.map((item, indexData) =>
        indexData === index
          ? {
            ...item,
            package_operating_start_time: id,
            error: { ...item.error, package_operating_start_time: "" },
          }
          : item
      )
    );

    let labels = [...fromTimeLabel];

    labels[index] = id;
    setFromTimeLabel(labels);

    setShowDropDown({ from: false });
  };
  const handelToTime = (e, id, key, index) => {



    setTotime(
      moment(`${id} ${toTimeAmPm[index]}`, "hh:mm A").format("HH:mm:ss")
    );
    setShowDropDown({ to: false });
    // const values = [...fields];
    setToVal(id);
    // values[index]["package_operating_end_time"] = moment(
    //   `${id} ${toTimeAmPm[index]}`,
    //   "hh:mm A"
    // ).format("HH:mm:ss");
    // values[index]["package_operating_end_time"] = id;
    setFields((previousData) =>
      previousData.map((item, indexData) =>
        indexData === index
          ? {
            ...item,
            package_operating_end_time: id,
            error: { ...item.error, package_operating_end_time: "" },
          }
          : item
      )
    );

    let labels = [...toTimeLabel];
    labels[index] = id;

    setToTimeLabel(labels);
  };

  const handelFromTImeAmPm = (e, i) => {
    setIndex(i);
    setFromTimeAmPm({ ...fromTimeAmPm, [i]: e.currentTarget.id });
    setShowDropDown({ from: false, to: false });
    setFields((previousData) =>
      previousData.map((item, indexData) =>
        indexData === i
          ? {
            ...item,
            error: { ...item.error, package_operating_start_time: "" },
          }
          : item
      )
    );
  };
  const handelToTimeAmPm = (e, i) => {
    setIndex(i);
    setToTimeAmPm({ ...toTimeAmPm, [i]: e.currentTarget.id });
    setShowDropDown({ from: false, to: false });
    setFields((previousData) =>
      previousData.map((item, indexData) =>
        indexData === i
          ? {
            ...item,
            error: { ...item.error, package_operating_end_time: "" },
          }
          : item
      )
    );
  };

  const finalRequest = [...fields];

  // for (var i = 0; i < finalRequest.length; i++) {
  //   finalRequest[i].from_time = moment(
  //     `${finalRequest[i].from_time} ${fromTimeAmPm[i]}`,
  //     "hh:mm A"
  //   ).format("HH:mm:ss");
  //   finalRequest[i].to_time = moment(
  //     `${finalRequest[i].to_time} ${toTimeAmPm[i]}`,
  //     "hh:mm A"
  //   ).format("HH:mm:ss");
  // }
  const corporateData = {
    data: [...bookingProfile.corporate.data],
  };

  const fullData = { ...bookingProfile };
  const submit = async () => {
    if (isEdit === true) {
      corporateData.data[Index]["package_operating_start_time"] = moment(
        `${fromtime} ${fromTimeAmPm[Index]}`,
        "hh:mm A"
      ).format("HH:mm:ss");
      corporateData.data[Index]["package_operating_end_time"] = moment(
        `${totime} ${toTimeAmPm[Index]}`,
        "hh:mm A"
      ).format("HH:mm:ss");

      const corporateObj = {
        ...fullData,
        corporate: {
          data: corporateData.data,
        },
      };

      const editRequest = {
        config_data: {
          site: "admin",
          module: "settings",
          config_key: "booking_time",
          value: corporateObj,
        },
      };
      const url = process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
      const response = await axiosPrivate.post(url, editRequest);

      if (response?.data?.status === 200) {
        setSuccessMessage("");
        setErrorMessage("");
        setTimeout(() => {
          setSuccessMessage("");
          setErrorMessage("");
          setFromTimeAmPm("");
          setToTimeAmPm("");
          setFromtime("");
          setTotime("");
          onBackdropClick(true);
          setFields([
            {
              key: Date.now(),
              package_operating_start_time: "",
              package_operating_end_time: "",
            },
          ]);
          setSuccess(!success);
        }, 3000);
        setSuccessMessage("Data updated successfully");
      } else {
        setSuccessMessage("");
        setErrorMessage("");
        setErrorMessage(response?.data?.message);
      }
    } else if (
      fields.every((itemMain, indexData) =>
        Object.values(itemMain).every(
          (item) =>
            item !== undefined && item !== "" &&
            fromTimeAmPm[indexData] !== undefined && fromTimeAmPm[indexData] !== "" &&
            toTimeAmPm[indexData] !== undefined && toTimeAmPm[indexData] !== ""
        )
      )
    ) {
      let array = fields.every((itemMain) =>
        Object.values(itemMain).every((item) => item === "")
      )
        ? []
        : fields;
      array = array.map((item, index) => ({
        package_operating_start_time: moment(
          `${item.package_operating_start_time} ${fromTimeAmPm[index]}`,
          "hh:mm A"
        ).format("HH:mm:ss"),
        package_operating_end_time: moment(
          `${item.package_operating_end_time} ${toTimeAmPm[index]}`,
          "hh:mm A"
        ).format("HH:mm:ss"),
      }));
      // array.map((arr) => {
      //   delete arr.from_time;
      //   delete arr.to_time;
      // });
      // console.log(array, "aaaaaaaaaaa");
      const corporateObj = corporateData.data.concat(array);

      // console.log(corporateObj, "obj");
      corporateObj.map((obj) => {
        delete obj.key;
      });
      const fulldata = {
        ...bookingProfile,
        corporate: { data: corporateObj },
      };

      const addRequest = {
        config_data: {
          site: "admin",
          module: "settings",
          config_key: "booking_time",
          value: fulldata,
        },
      };
      const url = process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
      const response = await axiosPrivate.post(url, addRequest);

      if (response?.data?.status === 200) {
        setSuccessMessage("");
        setErrorMessage("");
        setTimeout(() => {
          onBackdropClick(true);
          setFromTimeLabel([]);
          setToTimeLabel([]);
          setErrorMessage("");
          setSuccessMessage("");
          setFields([]);
          setSuccess(!success);
        }, 3000);
        setSuccessMessage("Data updated successfully");
      } else {
        setSuccessMessage("");
        setErrorMessage("");
        setErrorMessage(response?.data?.message);
      }
    } else {
      let fieldsArray = new Array();
      fields.map((item, indexx) => {
        let mainObject = { ...item };
        if (item.package_operating_start_time === "" || item.package_operating_start_time === undefined || fromTimeAmPm[indexx] === undefined || fromTimeAmPm[indexx] == "") {
          mainObject = {
            ...mainObject,
            error: {
              ...mainObject.error,
              package_operating_start_time:
                "Please select both time and am/pm.",
            },
          };
        }
        if (item.package_operating_end_time === "" || item.package_operating_end_time === undefined || toTimeAmPm[indexx] === undefined || toTimeAmPm[indexx] == "") {

          mainObject = {
            ...mainObject,
            error: {
              ...mainObject.error,
              package_operating_end_time: "Please select both time and am/pm.",
            },
          };
        }
        fieldsArray.push(mainObject);
      });
      setFields(fieldsArray);
    }
    setDeleteMode(false);

    // const url = process.env.REACT_APP_UPDATE_CANCELLATION_SETTINGS;
    // const response = await axiosPrivate.post(url, request);
    // console.log(response);
  };
  //   "booking_time_corporate": [
  //     {
  //         "id": "5",
  //         "p_a_id": "5",
  //         "from_time": "07:00:00",
  //         "to_time": "23:00:00"
  //     },
  //     {
  //         "id": "10",
  //         "p_a_id": "5",
  //         "from_time": "01:00:00",
  //         "to_time": "06:00:00"
  //     }
  // ],
  // console.log(amPm, "dfgdfgsd");
  // var convertedTime = moment(`1 ${amPm}`, "hh:mm A").format("HH:mm:ss");
  // console.log(convertedTime, "ccc");
  // Output: 13:00

  return (
    openPopup && (
      <Overlay>
        <div
          class="model_box_child manageBookingTimeP Corporate"
          id="manageBookingTimeP_Corporate"
          style={{ width: "500px" }}
        >
          <div class="ap_heading">
            <h4>
              Manage booking time{" "}
              <span
                onClick={handelClose}
                class="material-symbols-rounded black close_model"
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP">
              <div class="promoText customer">
                <h4>Corporate</h4>
                <p>2 booking time slot</p>
              </div>
              <div class="timesList">
                <ul>
                  {bookingProfile && bookingProfile?.corporate ? (
                    <>
                      {bookingProfile?.corporate?.data.map(
                        (bookingTimeCorporate, i) => {
                          return (
                            <>
                              <li>
                                <span>
                                  {SettingTime(
                                    bookingTimeCorporate?.package_operating_start_time
                                  ) +
                                    " - " +
                                    SettingTime(
                                      bookingTimeCorporate?.package_operating_end_time
                                    )}
                                </span>
                                <div class="icons">
                                  <i
                                    id={i}
                                    class="material-symbols-rounded mt-m"
                                    onClick={(e) => edit(e, i)}
                                  >
                                    edit
                                  </i>
                                  <i
                                    onClick={(e) =>
                                      handeldelete(e, bookingTimeCorporate.key)
                                    }
                                    class="material-symbols-rounded mt-m"
                                  >
                                    delete
                                  </i>
                                </div>
                              </li>
                            </>
                          );
                        }
                      )}
                    </>
                  ) : (
                    <></>
                  )}

                  {/* <div class="icons">
                      <i
                        class="material-symbols-rounded mt-m"
                        onClick={(e) => edit(e)}
                      >
                        edit
                      </i>
                      <i class="material-symbols-rounded mt-m">delete</i>
                    </div> */}
                </ul>
              </div>
              <div class="addTime dForm">
                {fields.map((field, index) => {
                  return (
                    <>
                      <div class="lists">
                        <div class="xType alignBottom">
                          <div class="fieldGroup">
                            {/*<em class="smallLabel">Minimum time</em>*/}
                            <span class="">
                              <div class="multiOption">
                                <div
                                  ref={minTimeRef}
                                  id="from"
                                  onClick={(e) =>
                                    setShowFromDropdown({
                                      [index]: !showFromDropdown[index],
                                    })
                                  }
                                  class={
                                    showFromDropdown[index] === true
                                      ? "selectBox open"
                                      : "selectBox"
                                  }
                                >
                                  {isEdit ? (
                                    <p class="selected">
                                      {isEdit &&
                                        fromtime &&
                                        typeof fromtime === "string" &&
                                        fromtime.includes(":")
                                        ? fromtime.split(":")[0]
                                        : isEdit && fromtime
                                          ? fromtime
                                          : "Select time"}
                                      <i class="material-symbols-rounded grey">
                                        expand_more
                                      </i>
                                    </p>
                                  ) : (
                                    <p class="selected">
                                      {fromTimeLabel[isEdit === true ? Index : index]
                                        ? fromTimeLabel[isEdit === true ? Index : index]
                                        : "Select time"}
                                      <i class="material-symbols-rounded grey">
                                        expand_more
                                      </i>
                                    </p>
                                  )}
                                  <div class="selectDrop customScroll hFix">
                                    <ul class="dropMenu">
                                      {Array.apply(
                                        null,
                                        Array(parseInt(12))
                                      ).map(function (x, i) {
                                        return (
                                          <li
                                            class={
                                              fromtime === i + 1
                                                ? "selected"
                                                : ""
                                            }
                                          >
                                            <a
                                              href="javascript:void(0);"
                                              id={i + 1}
                                              onClick={(e) =>
                                                handelFromTime(
                                                  e,
                                                  i + 1,
                                                  fields.key,
                                                  index
                                                )
                                              }
                                            >
                                              {i + 1}
                                              {fromtime === i + 1 ? (
                                                <i class="material-symbols-rounded">
                                                  done
                                                </i>
                                              ) : (
                                                ""
                                              )}
                                            </a>
                                          </li>
                                        );
                                      })}
                                    </ul>
                                  </div>
                                </div>
                                <div class="sepText">
                                  <span
                                    id="am"
                                    onClick={(e) =>
                                      handelFromTImeAmPm(
                                        e,
                                        isEdit === true ? Index : index
                                      )
                                    }
                                    className={
                                      isEdit === true &&
                                        fromTimeAmPm[Index] == "am"
                                        ? "active"
                                        : isEdit !== true &&
                                          fromTimeAmPm[index] == "am"
                                          ? "active"
                                          : ""
                                    }
                                  >
                                    am
                                  </span>

                                  <span
                                    id="pm"
                                    onClick={(e) =>
                                      handelFromTImeAmPm(
                                        e,
                                        isEdit === true ? Index : index
                                      )
                                    }
                                    class={
                                      isEdit === true &&
                                        fromTimeAmPm[Index] == "pm"
                                        ? "active"
                                        : isEdit !== true &&
                                          fromTimeAmPm[index] == "pm"
                                          ? "active"
                                          : ""
                                    }
                                  >
                                    pm
                                  </span>
                                </div>
                              </div>
                            </span>
                            <Error
                              error={field?.error?.package_operating_start_time}
                            />
                          </div>
                          <div class="fieldGroup">
                            {/*<em class="smallLabel">Maximum time</em>*/}
                            <span>
                              <div class="multiOption">
                                <div
                                  ref={maxTimeRef}
                                  id="to"
                                  onClick={(e) =>
                                    setShowToDropdown({
                                      [index]: !showToDropdown[index],
                                    })
                                  }
                                  class={
                                    showToDropdown[index] === true
                                      ? "selectBox open"
                                      : "selectBox"
                                  }
                                >
                                  {isEdit ? (
                                    <p class="selected">
                                      {isEdit &&
                                        totime &&
                                        typeof totime === "string" &&
                                        totime.includes(":")
                                        ? totime.split(":")[0]
                                        : isEdit && totime
                                          ? totime
                                          : "Select time"}
                                      <i class="material-symbols-rounded grey">
                                        expand_more
                                      </i>
                                    </p>
                                  ) : (
                                    <p class="selected">
                                      {toTimeLabel[isEdit === true ? Index : index]
                                        ? toTimeLabel[isEdit === true ? Index : index]
                                        : "Select time"}
                                      <i class="material-symbols-rounded grey">
                                        expand_more
                                      </i>
                                    </p>
                                  )}

                                  <div class="selectDrop customScroll hFix">
                                    <ul class="dropMenu">
                                      {Array.apply(
                                        null,
                                        Array(parseInt(12))
                                      ).map(function (x, i) {
                                        return (
                                          <li
                                            class={
                                              totime === i + 1 ? "selected" : ""
                                            }
                                          >
                                            <a
                                              href="javascript:void(0);"
                                              id={i + 1}
                                              onClick={(e) =>
                                                handelToTime(
                                                  e,
                                                  i + 1,
                                                  fields.key,
                                                  index
                                                )
                                              }
                                            >
                                              {i + 1}
                                              {totime === i + 1 ? (
                                                <i class="material-symbols-rounded">
                                                  done
                                                </i>
                                              ) : (
                                                ""
                                              )}
                                            </a>
                                          </li>
                                        );
                                      })}
                                    </ul>
                                  </div>
                                </div>
                                <div class="sepText">
                                  <span
                                    id="am"
                                    onClick={(e) =>
                                      handelToTimeAmPm(
                                        e,
                                        isEdit === true ? Index : index
                                      )
                                    }
                                    class={
                                      isEdit === true &&
                                        toTimeAmPm[Index] == "am"
                                        ? "active"
                                        : isEdit !== true &&
                                          toTimeAmPm[index] == "am"
                                          ? "active"
                                          : ""
                                    }
                                  >
                                    am
                                  </span>
                                  <span
                                    id="pm"
                                    onClick={(e) =>
                                      handelToTimeAmPm(
                                        e,
                                        isEdit === true ? Index : index
                                      )
                                    }
                                    class={
                                      isEdit === true &&
                                        toTimeAmPm[Index] == "pm"
                                        ? "active"
                                        : isEdit !== true &&
                                          toTimeAmPm[index] == "pm"
                                          ? "active"
                                          : ""
                                    }
                                  >
                                    pm
                                  </span>
                                </div>
                              </div>
                            </span>
                            <Error
                              error={field?.error?.package_operating_end_time}
                            />
                          </div>
                          {isEdit === false && (
                            <div
                              class="fieldGroup"
                              onClick={(e) =>
                                deleteField(
                                  e,
                                  isEdit === true ? Index : index,
                                  field.key
                                )
                              }
                            >
                              <i class="material-symbols-rounded mt-m">
                                delete
                              </i>
                            </div>
                          )}
                        </div>
                      </div>
                    </>
                  );
                })}
                {isEdit === false && (
                  <div class="link" onClick={add}>
                    <i class="material-symbols-rounded mt-m">more_time</i>
                    <a href="javascript:void(0);">Add new booking time</a>
                  </div>
                )}
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a
                  href="javascript:void(0);"
                  class="btn prim fullW"
                  onClick={submit}
                >
                  Save
                </a>
              </span>
            </div>
            {successMessage && <Success success={successMessage} />}
            {errorMessage && <Error error={errorMessage} />}
          </div>
        </div>
      </Overlay>
    )
  );
};

export default ManageCorporateBookingTime;
