import React from 'react'
import { useState, useEffect } from 'react'
import AnnualLeaves from './AnnualLeaves/AnnualLeaves'
import MeadicalLeaves from './MedicalLeaves/MeadicalLeaves'
import PublicHolidays from './PublicHolidays/PublicHolidays'
import ManagePublicHolidays from './PublicHolidays/ManagePublicHolidays'
import { axiosPrivate } from '../../../api/PrivateRequestServices'
import NoPriviliges from '../../UI/NoPriviliges'
import Spinner from '../../UI/Spinner'
import useAuth from '../../../hooks/useAuth'

const Leaves = () => {
    const { auth } = useAuth();
    const [showPopUp, setShowPopUp] = useState({
        annualLeaves: false,
        medicalLeaves: false,
        publicHolidays: false
    });
    const onBackDropClick = () => {
        setShowPopUp({
            annualLeaves: false,
            medicalLeaves: false,
            publicHolidays: false
        })
        document.body.classList.remove("hidden");
    }
    const [holidayCount, setHolidayCount] = useState("");
    const [isLoading, setIsLoading] = useState(true);
    const [holidayList, setHolidayList] = useState([])
    const [isSuccess, setIsSuccess] = useState();
    useEffect(() => {
        const getData = async () => {

            const holidayListUrl = process.env.REACT_APP_GET_HOLIDAY_LIST;
            const holidayListResponse = await axiosPrivate.get(holidayListUrl);
            setIsLoading(true);
            if (holidayListResponse.status == 200) {
                setIsLoading(false);
                setHolidayList(holidayListResponse?.data?.response?.data?holidayListResponse?.data?.response?.data:[]);
                setHolidayCount(holidayListResponse?.data?.response?.data?holidayListResponse?.data?.response?.data.length:"0")
               

            }

        }
        getData();

    }, [isSuccess])

    return (

        <>
            {showPopUp.publicHolidays == true && <ManagePublicHolidays setIsLoading={setIsLoading} isSuccess={isSuccess} setIsSuccess={setIsSuccess} holidayList={holidayList} setHolidayList={setHolidayList} isLoading={isLoading} holidayCount={holidayCount} setHolidayCount={setHolidayCount} onBackDropClick={onBackDropClick} />}
            {auth.priviliges.length>0?auth.priviliges.includes("read_settings") ?
                <div class="yRow mt-24 rowLists">
                    <div class="boxT1">
                        <div class="item">
                            <div class="text">
                                <h4>Leaves</h4>
                                <span>Manage public holiday</span>
                            </div>
                            {/* <!-- <i class="material-symbols-rounded arrowBottom mt-l">
                        expand_more
                    </i> --> */}

                        </div>
                        <div class="tableList mt-16">
                            <div>
                                {/* <!-- <h5>Service fee</h5> --> */}
                                <table class="widthAuto">
                                    <tbody>
                                        <tr>
                                            {/* <AnnualLeaves />
                                        <MeadicalLeaves /> */}
                                            <PublicHolidays showPopUp={showPopUp} isLoading={isLoading} setShowPopUp={setShowPopUp} holidayCount={holidayCount} />
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div> : <NoPriviliges />:<Spinner/>}




        </>
    )
}

export default Leaves