import React, { useEffect, useState } from 'react'
import Overlay from '../../../../utils/Overlay'
import { axiosPrivate } from '../../../../api/PrivateRequestServices';
import Error from '../../../UI/Error';
import Spinner from "../../../UI/Spinner"
import Success from '../../../UI/Success';
import { publicHolidayCode } from '../../../../configuration/GlobalConfig';

const ManagePublicHolidays = ({ setIsLoading, isSuccess, setIsSuccess, holidayList, setHolidayList, isLoading, holidayCount, setHolidayCount, onBackDropClick }) => {
    const [isSubmit, setIsSubmit] = useState(true);
    const [apiError, setApiError] = useState({});
    const [apiSuccess, setApiSuccess] = useState("")
    const [holidayInfo, setHolidayInfo] = useState({
        date: "",
        title: "",
        index: ""
    })
    const [editErr, setEditErr] = useState({
        name: "",
        date: ""
    })


    const [isEdit, setIsEdit] = useState(false);
    const [fields, setFields] = useState([{
        key: Date.now(),
        holidayDate: "",
        holidayName: "",
        dateErr: "",
        nameErr: "",

    }])
    const addNewHoliday = () => {
        setFields([...fields, {
            key: Date.now(),
            holidayDate: "",
            holidayName: "",
            dateErr: "",
            nameErr: "",
        }])
    }
    const handleremove = (id, index) => {
        const filtered = fields.filter((obj) => {
            return obj.key !== id;
        });
        setFields(filtered);
    };
    const editHoliday = (holiday, index) => {
        setIsEdit(true)
        setHolidayInfo({
            date: holiday.holiday_date,
            title: holiday.title ? holiday.title : holiday.holiday_title,
            index: index
        })

    }
    const handleEditHolidayDate = (e) => {
        setEditErr({ ...editErr, date: "" })
        setHolidayInfo((prev) => {
            return {
                ...prev,
                date: e.target.value
            }
        })
    }
    const handleEditHolidayName = (e) => {
        setEditErr({ ...editErr, name: "" })
        setHolidayInfo((prev) => {
            return {
                ...prev,
                title: e.target.value
            }
        })
    }
    const addNewHolidayDate = (e, index) => {
        const data = [...fields];
        data[index]['dateErr'] = "";
        data[index]['holidayDate'] = e.target.value;
        setFields(data);
    }
    const addNewHolidayname = (e, index) => {
        const data = [...fields];
        data[index]['nameErr'] = "";
        data[index]['holidayName'] = e.target.value;
        setFields(data);
    }
    const handeldelete = async (e, id) => {
        setIsLoading(true);


        if (isSubmit == true) {
            let request = [{
                "holiday_id": id,
                "status": 0
            }];
            const updateHolidayStatusUrl = process.env.REACT_APP_UPDATE_HOLIDAY_STATUS;
            const updateHolidayStatusResponse = await axiosPrivate.post(updateHolidayStatusUrl, request);
            setIsSubmit(false);
            setIsLoading(false);
            if (updateHolidayStatusResponse?.data?.response?.errors != undefined) {
                setIsSubmit(true);
                updateHolidayStatusResponse?.data?.response?.errors.map((errorData) => {

                    setApiError((prev) => {
                        const errDate = errorData.holiday_date
                        return {

                            ...prev,
                            [errDate]: errorData?.error?.message
                        }
                    })
                })
            }
            if (updateHolidayStatusResponse?.data?.response?.data?.success.length > 0) {
                setIsSubmit(false);
                let finalRequestArr = updateHolidayStatusResponse?.data?.response?.data?.success;
                const holidayList_temp = [...holidayList];
                holidayList_temp.splice(holidayList_temp.findIndex(function (i) {
                    return i.holiday_id === id;
                }), 1);
                setHolidayList(holidayList_temp);
                setApiSuccess("Holiday deleted successfully");
                setIsSubmit(true)
                setTimeout(() => {

                    setApiSuccess("");
                }, 2000)

                //setIsSuccess(!isSuccess);
                setHolidayCount(holidayList_temp.length);

            }
        }


    };
    const validations = (field) => {
        const data = [...field];
        let isValid = true;
        if (isEdit == true && holidayInfo.title == "") {
            isValid = false;
            setEditErr((prev) => {
                return {
                    ...prev,
                    name: "Please enter holiday name"
                }
            })
        }
        for (var i = 0; i < data.length; i++) {
            if (data[i].holidayDate == "" && isEdit == false) {
                data[i].dateErr = "Please select holiday date"
                isValid = false;
            }
            if (data[i].holidayName == "" && isEdit == false) {
                data[i].nameErr = "Please enter holiday name"
                isValid = false;
            }
        }
        setFields(data)
        return isValid;
    }

    const saveHoliday = async () => {

        setIsLoading(true);

        const allData = [...fields];
        let request = [];
        const isValid = validations(allData)
        { isValid == true ? setIsSubmit(false) : setIsSubmit(true) };
        { isValid == true && setIsLoading(true) }

        if (isEdit == true) {
            request = [];
            request = [{
                "holiday_date": holidayInfo.date,
                "holiday_title": holidayInfo.title,
                "holiday_code": publicHolidayCode
            }]
        }
        if (isEdit == false) {
            request = [];
            allData.map((data) => {
                return (
                    request.push(
                        {
                            "holiday_date": data.holidayDate,
                            "holiday_title": data.holidayName,
                            "holiday_code": publicHolidayCode
                        }
                    )
                )
            })
        }

        if (isValid == true && isSubmit == true) {
            const saveHolidayUrl = process.env.REACT_APP_SAVE_HOLIDAY_LIST
            const saveHolidayResponse = await axiosPrivate.post(saveHolidayUrl, request);
            setIsSubmit(false);
            setIsLoading(false);
            if (saveHolidayResponse?.data?.response?.errors != undefined) {
                setIsSubmit(true);
                saveHolidayResponse?.data?.response?.errors.map((errorData) => {

                    setApiError((prev) => {
                        const errDate = errorData.holiday_date
                        return {

                            ...prev,
                            [errDate]: errorData?.error?.message

                        }
                    })

                })

            }

            if (saveHolidayResponse?.data?.response?.data?.success.length > 0) {
                setIsSubmit(false);
                let finalRequestArr = saveHolidayResponse?.data?.response?.data?.success;
                if (isEdit == false) {
                    const oldHolidayArr = [...holidayList];
                    const newHolidayArr = [...request];
                    const finalHolidayArr = oldHolidayArr.concat(newHolidayArr);

                    setHolidayList(finalHolidayArr);
                    setHolidayCount(finalHolidayArr.length);

                }
                else {
                    const holidaylist = [...holidayList];
                    holidaylist[holidayInfo.index]['title'] = holidayInfo.title;

                    setHolidayList(holidaylist);
                    setHolidayCount(holidaylist.length);

                }

                finalRequestArr.map((slotObj, index) => {

                });
                setApiSuccess("Holiday updated successfully");
                if (isEdit == false) {
                    setTimeout(() => {
                        onBackDropClick()

                        setIsSuccess(!isSuccess)
                    }, 3000)
                }
                else {
                    setTimeout(() => {


                        setApiSuccess("")
                        setIsEdit(false);
                        setIsSubmit(true);
                       


                    }, 1000);
                }


            }

        }
        else {
            setIsLoading(false);
        }
    }

    return (
        <Overlay onBackDropClick={onBackDropClick}>
            {isLoading == true && <Spinner />}
            <div class="model_box_child leavesmphP" id="leavesmphP" style={{ width: "500px" }}>
                <div class="ap_heading">
                    <h4>
                        Manage public holidays
                        <span onClick={onBackDropClick} class="material-symbols-rounded black close_model">
                            close
                        </span>
                    </h4>
                </div>
                <div class="contentSection">
                    <section class="assignPromoP dForm">


                        <section class="mt-16">
                            <h5 class="fw-600">{holidayCount} public holidays</h5>
                            <div class="slotssList">
                                <ul>
                                    {holidayList != undefined && holidayList.map((holiday, i) => {

                                        return (
                                            <li>
                                                <div class="flexFlowInitial gap8">
                                                    <span class="fw-600">{holiday.holiday_date}</span>
                                                    <p class="dot"></p><span>{holiday.title ? holiday.title : holiday.holiday_title}</span>

                                                </div>
                                                <div class="icons flexFlowInitial">
                                                    <i class="material-symbols-rounded mt-m" onClick={() => editHoliday(holiday, i)}>edit</i>
                                                    <i onClick={(e) =>
                                                        handeldelete(e, holiday.holiday_id, i)
                                                    } class="material-symbols-rounded mt-m">delete</i>
                                                </div>
                                            </li>
                                        )
                                    })}
                                </ul>
                            </div>

                            <div class="addSlot dForm">
                                {
                                    isEdit == false ? fields.map((field, index) => {
                                        return (

                                            <div class="lists">
                                                <div class="xType alignBottom">
                                                    <div class="fieldGroup fullWidth">
                                                        <em class="smallLabel">Holiday date</em>
                                                        <div class="multiOption">
                                                            <span class="absIcon" style={{ width: "90%" }}>
                                                                <input type="date" min={new Date().toISOString().split('T')[0]} value={field.holidayDate} onChange={(e) => addNewHolidayDate(e, index)} placeholder="DD/MM/YYYY" name="" />
                                                                <i class="material-symbols-rounded grey arrowBottom mt-m"></i>
                                                            </span>
                                                        </div>
                                                        {field.dateErr != "" && <Error error={field.dateErr} />}
                                                    </div>

                                                    <div class="fieldGroup fullWidth">
                                                        <em class="smallLabel">Holiday name</em>
                                                        <div class="multiOption">
                                                            <input type="text" value={field.holidayName} onChange={(e) => addNewHolidayname(e, index)} placeholder="Enter holiday name" name="" />
                                                        </div>
                                                        {field.nameErr != "" && <Error error={field.nameErr} />}
                                                    </div>
                                                    {
                                                        fields.length > 1 && index != 0 &&
                                                        <i onClick={() => {
                                                            handleremove(field.key, index);
                                                        }} class="material-symbols-rounded mt-m">delete</i>}
                                                </div>
                                            </div>


                                        )
                                    }) :
                                        <div class="lists">
                                            <div class="xType alignBottom">
                                                <div class="fieldGroup fullWidth">
                                                    <em class="smallLabel">Holiday date</em>
                                                    <div class="multiOption">
                                                        <span class="absIcon" style={{ width: "9o%" }}>
                                                            <input value={holidayInfo.date} placeholder="DD/MM/YYYY" name="" />
                                                            <i class="material-symbols-rounded grey arrowBottom mt-m"></i>
                                                        </span>
                                                    </div>
                                                    {editErr.date && <Error error={editErr.date} />}
                                                </div>
                                                <div class="fieldGroup fullWidth">
                                                    <em class="smallLabel">Holiday name</em>
                                                    <div class="multiOption">
                                                        <input type="text" onChange={handleEditHolidayName} value={holidayInfo.title} placeholder="Enter holiday name" name="" />
                                                    </div>
                                                    {editErr.name && <Error error={editErr.name} />}
                                                </div>

                                            </div>
                                        </div>
                                }
                                {
                                    isEdit != true &&
                                    <div class="link">
                                        <a onClick={addNewHoliday} href="javascript:void(0);">+  Add new holiday</a>
                                    </div>
                                }

                            </div>
                        </section>
                    </section>
                    {
                        Object.entries(apiError).map((errorData) => {
                            return (
                                <>
                                    {errorData[0] != undefined && <Error error={errorData[0] + ": " + errorData[1]} />}
                                    <br />
                                </>
                            )
                        })
                    }
                    {
                        apiSuccess && <Success success={apiSuccess} />
                    }

                    <div class="actionButtons mt-24">
                        <span>
                            <a onClick={saveHoliday} href="javascript:void(0);" class="btn prim">{isEdit == true ? "Update" : "Save"}</a>
                        </span>
                    </div>
                </div>
            </div>
        </Overlay>
    )
}
export default ManagePublicHolidays
