import React from 'react'

import useAuth from '../../../../hooks/useAuth';
import Spinner from '../../../UI/Spinner';

const PublicHolidays = ({ setShowPopUp,isLoading, holidayCount }) => {
    const { auth } = useAuth();

    return (
        <>
            {isLoading==true&&<Spinner/>}
        <td>
            <span>Public holidays</span>
            
                <span class="time">{holidayCount}
                    {auth.priviliges.includes("write_settings") &&
                        <a id="publicHolidays" onClick={() => setShowPopUp({ publicHolidays: true })} class="open_model" data-target="leavesmphP" href="javascript:void(0);">
                            Manage
                        </a>}
                </span>
            </td>
            </>
    )
}

export default PublicHolidays