import React from 'react'
import { useState, useEffect } from 'react'
import Overlay from '../../../utils/Overlay'
import useAxiosIntercept from '../../../hooks/useAxiosIntercept'
import Error from '../../UI/Error'
import Success from '../../UI/Success'



export default function ManageMapping({ partnerList, adminList, setMappingPopUp,heading,action,editData,isSuccess,setisSuccess,partners,setpartners,isToggle,setisToggleClicked}) {
    const axiosPrivate = useAxiosIntercept();
    const [showAdminList, setshowAdminList] = useState(false);
    const [error,setError]=useState("");
    const [editedAdmin,seteditedAdmin]=useState("");
    const [editedUserId,setEditedUserId]=useState("");
    const [showPartnerList, setshowPartnerList] = useState(false);
    const [adminLabel, setAdminLabel] = useState([]);
    const [partnerLabel, setPartnerLabel] = useState([]);
    const [successMessage,setSuccessMessage]=useState("")
    const [enableSubmit,setEnableSubmit]=useState(true);
    const [fields, setFields] = useState([
        {
            key: Date.now(),
            from_user_id: "",
            to_object_id: "",
            to_object_type: "P",

        },
    ]);
    let isAdminError = 0;
  let isPartnerError = 0;
    const adminInfo = (firstname, userid, index, event, lastname) => {
        const labels = [...adminLabel];
        labels[index] = firstname + " " + lastname;
        setAdminLabel(labels);
        const values = [...fields];
        values[index]["from_user_id"] = userid;
        values[index]["error"] = "";
        values[index]["from_user_id_err"]="";
        setFields(values);
        seteditedAdmin(firstname + " " + lastname);
        setEditedUserId(userid);
        setError("");

    };
    const partnerInfo = (name, partnerid, index, event) => {
        const labels = [...partnerLabel];
        labels[index] = name;
        setPartnerLabel(labels);
        const values = [...fields];
        values[index]["to_object_id"] = partnerid;
        values[index]["error"] = "";
        values[index]["to_object_id_err"]="";
        setFields(values);

    };
    const addAnotherMapping = () => {
        setFields([
            ...fields,
            {
                key: Date.now(),
                from_user_id: "",
                to_object_id: "",
                to_object_type: "P",
            },
        ]);
    };
    const validations = (fields) => {
        const data = [...fields];
    
        for (let index = 0; index < data.length; index++) {
          if (data[index]. from_user_id == "") {
            data[index]. from_user_id_err = "Admin is required";
          } else {
            isAdminError++;
            data[index].from_user_id_err  = "";
          }
    
          if (data[index].to_object_id == "") {
            data[index].to_object_id_err= "Partner is required";
          } else {
            data[index].to_object_id_err = "";
            isPartnerError++;
          }
        }
    
        setFields(data);
      };
    const createMappings = async () => {
        for (let i = 0; i < fields.length; i++) {
            delete fields[i]["from_user_id_err "];
            delete fields[i]["to_object_id_err"];
            delete fields[i]["error"];
        }
        const url = process.env.REACT_APP_ADD_NEW_PARTNER_MAPPING;
        const body = fields;
         
        
        validations(fields);
        if (isAdminError== fields.length && isPartnerError == fields.length&&enableSubmit==true) {
            setEnableSubmit(false);
            const response = await axiosPrivate.post(
              url,
              body
            );

            if(response?.data?.response?.errors&& response?.data?.response?.errors?.length > "0"){
                if(response?.data?.status=="200"){
                    setisSuccess(!isSuccess);
                }
                setEnableSubmit(true);
                const data = [...fields];
                fields.map((field, i) => {
                    if (response?.data?.response?.errors&& response?.data?.response?.errors?.length > "0") {
                        response?.data?.response?.errors.map((err, index) => {
            

                            if (field.key == err?.key) {
                                data[i].error = err?.errors[0]?.message

                            }

                        })
                    }

                })
                setFields(data);
                

            }
            else{
                setEnableSubmit(false);
                setisSuccess(!isSuccess);
                setisToggleClicked(true);
                setSuccessMessage("Mapping added successfully");
                setTimeout(() => {
                    setMappingPopUp(false);
                    document.body.classList.remove("hidden");

                    
    
                }, 3000);

            }
          }
        
        
    }
    const handleremove = (id, index) => {
        const filtered = fields.filter((obj) => {
          return obj.key !== id;
        });
    
        setFields(filtered);
    
        const adminlabels =[...adminLabel];
        adminlabels.splice(index, 1);
        setAdminLabel(adminlabels);
        const partnerlabels = [...partnerLabel];
        partnerlabels.splice(index, 1);
        setPartnerLabel(partnerlabels);
    
      
      };
      const editmapping= async()=>
      {
        if(fields[0].from_user_id==""){
            setError("Select admin");

        }
        if(enableSubmit==true&&fields[0].from_user_id!="")
        {
            setEnableSubmit(false);
            const body={
                mapping_id:editData.mapping_id,
                from_user_id:fields[0].from_user_id
            }
            const url=process.env.REACT_APP_EDIT_MAPPING;
            const response=await axiosPrivate.post(url,body);
            
            if(response?.data?.status=="200"){
                setEnableSubmit(false);
                if(isToggle==true){
                    const allpartners=[...partners];
                    allpartners[editData.index].admin_name=editedAdmin;
                    allpartners[editData.index].admin_user_id=editedUserId;
                    setpartners(allpartners);
    
                }
                else{
                    const allpartners=[...partners];
                    allpartners.splice(editData.index, 1);
                    setpartners(allpartners);
    
                   
    
    
                }
                
               
                setSuccessMessage("Mapping edited successfully");
                setTimeout(() => {
                    setMappingPopUp(false);
                    document.body.classList.remove("hidden");
                }, 3000);
    
            
            }
            else{
                setEnableSubmit(true);
                const data=[...fields];
                data[0]["error"] = response?.data?.response?.errors[0]?.message;
                setFields(data);
            }
    

        }
        
        
      }
    return (
        <>
            <Overlay>
                <div class="model_box_child manageSlotsP" id="manageSlotsP" style={{ width: "530px" }}>
                    <div class="ap_heading">
                        <h4><span>{heading}</span> <span class="material-symbols-rounded fill black close_model active" onClick={() => { setMappingPopUp(false);document.body.classList.remove("hidden"); }}>close</span></h4>
                    </div>
                    <div class="contentSection">

                        <section>

                            <div class="addSlot dForm">
                                {fields.map((field, index) => {
                                    return (<>
                                        <div class="lists">
                                            <div class="xType alignBottom">
                                            <div class="fieldGroup fullWidth">
                                                    <em class="smallLabel">Select partner</em>
                                                    <div class="multiOption"
                                                        onClick={action=="add"?() => {
                                                            setshowPartnerList({
                                                                [index]: !showPartnerList[index],
                                                            });
                                                        }:""}>
                                                        <div class={
                                                            showPartnerList[index]
                                                                ? "selectBox fullWidth open"
                                                                : "selectBox fullWidth"
                                                        }>
                                                          <p>{partnerLabel[index]?partnerLabel[index]:action=="edit"?editData.partnerName:"Select Partner"}
                                                          {action=="add"&& <i class="material-symbols-rounded grey">expand_more</i>}
                                                         
                                                          
                                                          </p>
                                                    
                                                            <div class="selectDrop customScroll hFix">
                                                                <ul class="dropMenu">
                                                                    {partnerList && partnerList?.length > 0 && partnerList?.map((partner, index2) => {
                                                                        return (<>
                                                                            <li onClick={(event) => {
                                                                                partnerInfo(
                                                                                    partner.partner_name,
                                                                                    partner.partner_id,
                                                                                    index,
                                                                                    event,

                                                                                );
                                                                            }}>
                                                                                <a>{partner.partner_name}</a>
                                                                            </li>

                                                                        </>)

                                                                    })}

                                                                </ul>
                                                            </div>
                                                            {field.to_object_id_err&& (
                                    <Error error={field.to_object_id_err} />
                                  )}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="fieldGroup fullWidth">
                                                    <em class="smallLabel">Select admin</em>
                                                    <div class="multiOption"
                                                        onClick={() => {
                                                            setshowAdminList({
                                                                [index]: !showAdminList[index],
                                                            });
                                                        }}
                                                    >
                                                        <div class={
                                                            showAdminList[index]
                                                                ? "selectBox fullWidth open"
                                                                : "selectBox fullWidth"
                                                        }>
                                                             <p>{adminLabel[index]?adminLabel[index]:action=="edit"?editData.adminName:"Select Admin"}
                                                          <i class="material-symbols-rounded grey">expand_more</i>
                                                          
                                                          </p>
                                                            <div class="selectDrop customScroll hFix">
                                                                <ul class="dropMenu">
                                                                    {adminList && adminList?.length > 0 && adminList.map((admin, index1) => {
                                                                        return (<>
                                                                            <li onClick={(event) => {
                                                                                adminInfo(
                                                                                    admin.firstname,
                                                                                    admin.user_id,
                                                                                    index,
                                                                                    event,
                                                                                    admin.lastname,


                                                                                );
                                                                            }}>
                                                                                <a>
                                                                                    {admin.firstname + " " + admin.lastname}

                                                                                </a>
                                                                            </li>

                                                                        </>)

                                                                    })}
                                                                </ul>
                                                            </div>
                                                            {field.from_user_id_err&& (
                                    <Error error={field.from_user_id_err} />
                                  )}
                                  {error&&<Error error={error}/>}
                                                        </div>
                                                    </div>
                                                </div>
                                               

                                                {fields.length > 1 && index != 0 && (
                              <div class="icons" style={{ marginTop: "60px" }}>
                                <i
                                  class="material-symbols-rounded mt-m"
                                  onClick={() => {
                                    handleremove(field.key, index);
                                  }}
                                >
                                  delete
                                </i>
                              </div>
                            )}

                                            </div>
                                        </div>
                                        {fields[index].error&&<Error error={fields[index].error}/>}

                                    </>)

                                })}
                                {action=="add"&&(<>
                                  <div class="link">
                                    <i class="material-symbols-rounded mt-m">more_time</i>
                                    <a onClick={addAnotherMapping}>Add another mapping</a>
                                </div>
                                </>)}

                               
                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a class="btn prim fullW" onClick={action=="edit"?editmapping:createMappings}>Update</a>
                            </span>
                            {successMessage && <Success success={successMessage} />}
                        </div>
                    </div>
                </div>

            </Overlay>

        </>
    )
}
