import React from 'react'
import { useState, useEffect, useRef } from 'react'
import useAxiosIntercept from '../../../hooks/useAxiosIntercept'
import useHttp from '../../../hooks/useHttp'
import usePaginate from '../../../hooks/usePaginate'
import NoData from '../../UI/NoData'
import Loading from '../../UI/Loading'
import PartnerListing from './PartnerListing'
export default function ManagePartner() {
    const axiosPrivate = useAxiosIntercept();
    const [allPrtners,setAllPartners]=useState("");
    const [myPartners, setmyPartners] = useState("");
    const [hasMore, setHasMore] = useState(false);
    const [total_records, setTotalRecords] = useState(0);
    const [pageNumber, setPageNumber] = useState(1);
    const [isToggle, setIsToggle] = useState(false);
    const [isSuccess,setisSuccess]=useState(false);
    const [isToggleClicked,setisToggleClicked]=useState(false);
    const prevSuccess = useRef({ isToggleClicked }).current;
    const { isLoading, sendRequest: getPartnerList } = useHttp();
    const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);
    const perpageLimit = 10;
    let url = process.env.REACT_APP_ACT_ON_BEHALF_PARTNER_LIST + `&page=${pageNumber}&limit=${perpageLimit}`
   
    useEffect(() => {
        
        
        if(isToggle == true){
            url=url+`&show_all=1`;

        }
        const setPartners = (partners) => {
            
            const { data } = partners?.data?.response;
            if (data?.partnerList && data?.partnerList?.length > 0) {
                if(isToggle==true){
                    if (prevSuccess.isToggleClicked !== isToggleClicked) {
                        setAllPartners(() => {
                            return ([...new Set([...data?.partnerList])])
    
                        })
                    }
                    else{
                        setAllPartners((prev) => {
                            return [...new Set([...prev, ...data?.partnerList])];
                        });

                    }
                  
                }
                else{
                    if (prevSuccess.isToggleClicked !== isToggleClicked) {
                        setmyPartners(() => {
                            return ([...new Set([...data?.partnerList])])
    
                        })
                    }
                    else{
                        setmyPartners((prev) => {
                            return [...new Set([...prev, ...data?.partnerList])];
                        });

                    }
                  

                }
               
                setTotalRecords(data?.total_records);
                setisToggleClicked(false);
            } else {
                setmyPartners({});
                setAllPartners({});
            }
            if (data?.total_records == data?.partnerList?.length) {
                setHasMore(false);
            }
            else {
                

                setHasMore(partners?.data?.response?.data?.partnerList?.length > 0);
            }
        }
       
        if (pageNumber == 1 || (Math.ceil(total_records / perpageLimit) >= pageNumber)) {

            getPartnerList(
                {
                    url
                },
                setPartners

            );
        }


    }, [url, getPartnerList, pageNumber,isToggle,isSuccess])
    return (
        <>
        
        
            <PartnerListing partners={isToggle?allPrtners:myPartners} setpartners={isToggle?setAllPartners:setmyPartners} lastElementRef={lastElementRef}  isToggle={isToggle} setIsToggle={setIsToggle} isSuccess={isSuccess} setisSuccess={setisSuccess} setPageNumber={setPageNumber} setAllPartners={setAllPartners} setmyPartners={setmyPartners}
            setisToggleClicked={setisToggleClicked}
            
            />
            <div>{isLoading && pageNumber != "1" && <Loading />}</div>
            {pageNumber != "1" && pageNumber > Math.ceil(total_records / perpageLimit) && (<NoData />)}

        </>
    )
}
