import React from 'react'
import { useState, useEffect } from 'react';
import useAxiosIntercept from '../../../hooks/useAxiosIntercept';
import Spinner from '../../UI/Spinner';
import { Link } from 'react-router-dom';
import Cookies from 'universal-cookie';
import useAuth from '../../../hooks/useAuth';
import { canLoginMultiplePartners } from '../../../configuration/GlobalConfig';
import NotificationNew from '../../../utils/NotificationNew';
import Message from '../../../utils/Message';
import ManageMapping from './ManageMapping';
import DataNotFound from '../../UI/DataNotFound';
import NoPriviliges from '../../UI/NoPriviliges';
export default function PartnerListing({ partners, setpartners,lastElementRef ,isToggle,setIsToggle,isSuccess,setisSuccess,setPageNumber,setAllPartners,setmyPartners,setisToggleClicked}) {

    const { auth } = useAuth();
    const axiosPrivate = useAxiosIntercept();
    const cookies = new Cookies();
    const [errorMessage, setErrorMessage] = useState(false);
    const [mappingPopUp, setMappingPopUp] = useState(false);
    const [editPopUp,seteditPopUp]=useState(false);
    const [errorData, setErrorData] = useState("");
    const [adminList, setadminList] = useState("");
    const [partnerList, setpartnerList] = useState("");
    const [editData,setEditData]=useState({
        adminName:"",
        partnerName:"",
        mappingId:""


    });
    
    const [deletePopUp,setdeletePopUP]=useState(false);
    const [notifyData, setNotifyData] = useState();
    const [toggleValue,setToggleValue]=useState("onlymine");
    const isRoot = auth?.userIsRoot?auth?.userIsRoot.toLowerCase():"";
    const loggedInUser=auth?.userId;
    const manageMapping = async () => {
        setMappingPopUp(true);
        const admin_list_url = process.env.REACT_APP_GET_ADMIN_LIST + `&user_type=A&limit=1000`;
        const partner_list_url = process.env.REACT_APP_GET_PARTNER_LIST_FOR_CUSTOMERS+`&limit=1000&status=A`;
        const admin_list = await axiosPrivate.get(admin_list_url);
        const partner_list = await axiosPrivate.get(partner_list_url);
        if (admin_list?.data?.status == "200") {
            setadminList(admin_list?.data?.response?.data?.user_info);
        }
        if (partner_list?.data?.status == "200") {
            setpartnerList(partner_list?.data?.response?.data?.partners)

        }


    }
    const onBackdropClick = () => {
        setErrorMessage(false);
        document.body.classList.remove('hidden');
    }
    const loginOnPartnerDashboard = async (partner_id) => {
        const URL = process.env.REACT_APP_ACT_ON_BEHALF;
        const body = {
            "partner_id": partner_id

        }
        if ((canLoginMultiplePartners == false && cookies.get("ulid_D_P") == undefined) || canLoginMultiplePartners == true) {
            const response = await axiosPrivate.post(URL, body);
            if (response?.data?.status == "200") {

                window.open(process.env.REACT_APP_PARTNER_URL, '_blank', 'noreferrer')
            }
            else {
                setErrorMessage(true);
                setErrorData({
                    message: {
                        text: response?.data?.response?.errors[0]?.message
                    },

                    errorValue: "Go back to partner listing",
                    isSuccess: false,
                    doNotNavigate: true,
                    onBackdropClick: onBackdropClick
                })
            }

        }
        else {

            setErrorData({
                message: {
                    text: "Kindly logout existing partner before logging in to another partner"
                },

                errorValue: "Go back to partner dashboard",
                isSuccess: false,
                externalLink: process.env.REACT_APP_PARTNER_URL,
                onBackdropClick: onBackdropClick
            })

            setErrorMessage(true);
        }

    }
    const handleToggle = () => {
       setPageNumber(1);
       setisToggleClicked(true);
    //   setAllPartners({});
    //    setmyPartners({})
        setIsToggle(!isToggle);
        setToggleValue(!isToggle == true ? "all" : "onlymine");
      };
      const handleEdit=async (partner_name,admin_name,mapping_id,index)=>{
        seteditPopUp(true);
        setEditData({
            adminName:admin_name,
            partnerName:partner_name,
            mapping_id:mapping_id,
            index:index

        })
       const admin_list_url = process.env.REACT_APP_GET_ADMIN_LIST + `&user_type=A&limit=1000`;
        const admin_list = await axiosPrivate.get(admin_list_url);
        if (admin_list?.data?.status == "200") {
            setadminList(admin_list?.data?.response?.data?.user_info);
        }
       

      }
      const removeMappingFromList= (index) => {
        const temp = [...partners];
        temp.splice(index, 1);
        setpartners(temp);

    }
    const removeMapping = (operation_status) => {
        if (operation_status === true) {
            removeMappingFromList(notifyData.index)
        }
        setdeletePopUP(false);
        document.body.classList.remove('hidden');
    }

      const deleteMapping=async (mapping_id,index,name)=>{
        setdeletePopUP(true);
        setNotifyData({
            index: index,
            name:name,
            heading: "Are you sure you want to delete mapping?",
            buttonNameYes: "Yes,delete",
            buttonNameNo: "No,don't delete",
            success: "Mapping deleted successfully",
            url: process.env.REACT_APP_EDIT_MAPPING,
            apiRequest: {
                mapping_id:mapping_id,
            status:0

            },
        })
      
       

      }
    
    return (
        <>
        
        {deletePopUp&&<NotificationNew onBackdropClick={removeMapping} notifyData={notifyData}/>}
        {editPopUp&&<ManageMapping partnerList={""} adminList={adminList} setMappingPopUp={seteditPopUp} heading={"Edit mapping"} action={"edit"} editData={editData} partners={partners} setpartners={setpartners} isToggle={isToggle}/>}
            {mappingPopUp && <ManageMapping partnerList={partnerList} adminList={adminList} setMappingPopUp={setMappingPopUp} heading={"Add mapping"} action={"add"} isSuccess={isSuccess} setisSuccess={setisSuccess} setisToggleClicked={setisToggleClicked}/>}
            {errorMessage && <Message
                message={errorData.message}
                errorValue={errorData.errorValue}
                isSuccess={errorData.isSuccess}
                onBackdropClick={onBackdropClick}
                setShowMessage={setErrorMessage}
                doNotNavigate={true}
                externalLink={errorData.externalLink}

            />}
            <div class="mt-24">
                <div class="searchPanel mb-24">
                    <h3>Manage Partner</h3>
                     {auth.priviliges.includes("write_partner_settings")&& <div class="xRow"><em style={{paddingRight:"10px"}} >Managed by me</em><label class="toggleSwitch fType"><input type="checkbox" onClick={(e) => handleToggle(e)}
                    checked={isToggle && true}/><span class="slider round"></span></label><em style={{paddingLeft:"10px"}}>View all</em></div>}
                    
                    { auth.priviliges.includes("write_partner_settings") && <a onClick={manageMapping} class="btn prim open_model" data-target="manageMapping">Manage mapping</a>}
                </div>
                {partners === "" ? <Spinner /> : Object.keys(partners).length != "0" ? (<>
                    {auth.priviliges.includes("read_partner_settings") ?
                        <div class="dataTableDynamic">
                            <table>
                                <tbody>
                                    <tr>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        {toggleValue == "all" && <th>Admin name</th>}
                                        <th>&nbsp;</th>
                                        {auth.priviliges.includes("write_settings") && <>
                                        <th>&nbsp;</th>
                                        <th>&nbsp;</th></>}
                                    </tr>
                                    {partners && partners?.length > 0 ?
                                        partners.map((partner, index) => {
                                            if (partners?.length == index + 1) {
                                                return (<>
                                                    <tr ref={lastElementRef} key={index}>
                                                        <td class="vName"><span>{partner?.partner}</span></td>
                                                        <td>{partner?.email ? partner.email : "N/A"}</td>
                                                        <td>{partner?.phone ? partner?.phone : "N/A"}</td>
                                                        {toggleValue == "all" && <td>{partner?.admin_name ? partner.admin_name : ""}</td>}
                                                        <td>
                                                            {loggedInUser == partner.admin_user_id ? (<>
                                                                <Link onClick={() => { loginOnPartnerDashboard(partner.partner_id) }} class="open_model" data-target="editEmployee">View partner dashboard</Link>
                                                            </>) : "N/A"}
                                                        

                                                        </td>
                                                         {auth.priviliges.includes("write_partner_settings")&& 
                                                       (<>
                                                            <td><Link onClick={() => { handleEdit(partner?.partner, partner?.admin_name, partner.mapping_id, index) }}>Edit mapping</Link></td>
                                                            <td><Link onClick={() => { deleteMapping(partner.mapping_id, index, partner?.partner) }}>Delete mapping</Link></td>
                                                        </>)
                                                         } 
                                                    



                                                    </tr>

                                                </>)


                                            }
                                            else {
                                                return (<>

                                                    <tr key={index}>
                                                        <td class="vName"><span>{partner.partner}</span></td>

                                                        <td>{partner?.email ? partner.email : "N/A"}</td>
                                                        <td>{partner?.phone ? partner?.phone : "N/A"}</td>
                                                        {toggleValue == "all" && <td>{partner?.admin_name ? partner.admin_name : ""}</td>}
                                                        <td>
                                                            {loggedInUser == partner.admin_user_id ? (<>
                                                                <Link onClick={() => { loginOnPartnerDashboard(partner.partner_id) }} class="open_model" data-target="editEmployee">View partner dashboard</Link>
                                                            </>) : "N/A"}
                                                        

                                                        </td>
                                                        {auth.priviliges.includes("write_partner_settings")&& 
                                                        (<>
                                                            <td><Link onClick={() => { handleEdit(partner?.partner, partner?.admin_name, partner.mapping_id, index) }}>Edit mapping</Link></td>
                                                            <td><Link onClick={() => { deleteMapping(partner.mapping_id, index, partner?.partner) }}>Delete mapping</Link></td>
                                                        </>)
                                                         } 

                                                    </tr>

                                                </>)

                                            }



                                        })



                                        : ""}

                                </tbody>
                            </table>
                        </div> :<NoPriviliges/>}
                </>) : (
                       <NoPriviliges message={"No partner found"}/> 
                )}

            </div>


        </>
    )
}
