import React from "react";
import { useState } from "react";
import { Link } from "react-router-dom";
import GeneralTab from "./GeneralTab";
import ChargeAndTaxes from "../Settings/ChargeAndTaxes/ChargeAndTaxes";
import ChargesAndTaxesTab from "./ChargesAndTaxesTab";
import AttendantsTab from "./AttendantsTab";
import AddonsTab from "./AddonsTab";
import Brands from "./Brands/Brands";
import AddOns from "../Views/Settings/AddOns/AddOns";
import Addons from "../Views/Settings/AddOns/AddOns";
import AddOnsInfo from "./AddOns/AddOnsInfo";
import AttendantIncentive from "./Attendants/AttendantsIncentive";
import Employees from "./Employees/Employees";
import ManagePartner from "./ManagePartner/ManagePartner";
import { pageTitles } from "../../configuration/GlobalConfig";
import General from "./General/General";
import Leaves from "./Leaves/Leaves";
export default function SettingsInfo() {
  const [showSubComponent, setshowSubComponent] = useState({
    generalTab: true,
  });
  const handler = (e) => {
    setshowSubComponent({ [e.target.id]: true });
  };
  return (
    <>
      <div class="subContent">
        <div class="settings">
          <div class="navTabs mt-24">
            <ul class="level1">
              <li className={showSubComponent.generalTab ? "selected" : ""}>
                <Link id="generalTab" onClick={handler}>
                  General
                </Link>
              </li>
              <li className={showSubComponent.chargesTab ? "selected" : ""}>
                <Link id="chargesTab" onClick={handler}>
                  Charges &amp; Taxes
                </Link>
              </li>
              <li className={showSubComponent.addonsTab ? "selected" : ""}>
                <Link id="addonsTab" onClick={handler}>
                  Add-ons
                </Link>
              </li>
              <li className={showSubComponent.brandsTab ? "selected" : ""}>
                <Link id="brandsTab" onClick={handler}>
                  Brands
                </Link>
              </li>
              <li className={showSubComponent.attendantsTab ? "selected" : ""}>
                <Link id="attendantsTab" onClick={handler}>
                  Attendants
                </Link>
              </li>
              <li className={showSubComponent.employeesTab ? "selected" : ""}>
                <Link id="employeesTab" onClick={handler}>
                  Employees
                </Link>
              </li>
              <li className={showSubComponent.partnerTab ? "selected" : ""}>
                <Link id="partnerTab" onClick={handler}>
                  Manage Partner
                </Link>
              </li>
              <li className={showSubComponent.leavesTab ? "selected" : ""}>
                <Link id="leavesTab" onClick={handler}>
                  Leaves
                </Link>
              </li>
            </ul>
          </div>
          {/* here */}
          {showSubComponent.generalTab && <General />}
          {showSubComponent.chargesTab && <ChargeAndTaxes />}
          {showSubComponent.addonsTab && <AddOnsInfo />}
          {showSubComponent.attendantsTab && <AttendantIncentive />}
          {showSubComponent.brandsTab && (
            <Brands setshowSubComponent={setshowSubComponent} />
          )}
          {showSubComponent.employeesTab && (<Employees />)}
          {showSubComponent.partnerTab && (<ManagePartner />)}
          {showSubComponent.leavesTab&&<Leaves/>}
        </div>
      </div>
    </>
  );
}
