import React from 'react'
import Image from './Image'
import { FormatDate } from '../../utils/FormatDate'

const Card = ({userImage, userFirstName, userLastName, createdDate,className}) => {
    let fullName="";
    fullName=userFirstName?fullName+" "+userFirstName:"";
    fullName=userLastName?fullName+" "+userLastName:fullName;
  return (
    <div className={className.mainDivClass}>
    <Image userImage={userImage} name={userFirstName?userFirstName:"Guest"} className="imgBlock" />
    <div className={className.subDivClass}>
      {userFirstName?<span>{`${fullName}`}</span>:<span>Guest</span>}
      {createdDate?( <span>Active since: {FormatDate(createdDate)}</span>):<></>}
     
    </div>
  </div>
  )
}



export default Card