
import React from 'react';
import { Link } from 'react-router-dom';
export default function DropDown({ data, classobj, checkedOption, callBackFunction, listItemIdentifier }) {
  return (
    <>
      <div className={classobj.divClassName}>
        <ul className='dropMenu'>
          {data &&
            data.length > '0' &&
            data.map((listItem,i) => {
              return (
                <React.Fragment key={i.toString()}>
                  <li
                    className={checkedOption == listItem[listItemIdentifier] ? classobj.liClassName : ''}>
                    <Link
                      id={listItem.id}
                      onClick={(e) => callBackFunction(e, listItem.object != undefined ? listItem.object : listItem)}>
                      {listItem.label}
                      {listItem[listItemIdentifier] == checkedOption && <i className='material-symbols-rounded'>done</i>}
                    </Link>
                  </li>
                </React.Fragment>
              );
            })}
        </ul>
      </div>
    </>
  );
}
