import { findAllByTestId } from "@testing-library/react";
import React from "react";
import Error from "../../components/UI/Error";
import { recovery_insurance_category_type } from "../../configuration/createPackageFormConfigs";
const FieldElement = (props) => {
  const fieldConfig = props.fieldConfig;
  const changeAddonValues = (e,field_config,index) => {
    if(e.target.classList.contains('max_service_allowed')) {
        field_config.max_service_allowed=e.target.value;
    }
    if(e.target.classList.contains('service_charge')) {
        field_config.service_charge=e.target.value;
    }
    props.onFieldUpdateHandle(e,field_config,index,true);
  };
  const selectedOption = props.selectedOption;
  const isChecked = props.isChecked;
  let htmlInputType = null;
  switch (fieldConfig.type) {
    case "input":
      let input_classes = "";
      if (!fieldConfig?.object_key || !fieldConfig?.disableFieldGroup) {
        input_classes = "fieldGroup";
      }
      if (
        fieldConfig?.additionalClass !== undefined &&
        fieldConfig?.additionalClass != ""
      ) {
        input_classes += " " + fieldConfig?.additionalClass;
      }

      htmlInputType = (
        <div
          className={input_classes}
          style={
            fieldConfig.hidden
              ? {
                  display: selectedOption?.[fieldConfig.id] ? "block" : "none",
                  width: "300px",
                }
              : { display: "block", width: "300px" }
          }
        >
          {fieldConfig.displayLabel && (
            <label
              htmlFor={fieldConfig.id}
              style={{ fontWeight: "bold", fontSize: "16px" }}
            >
              {fieldConfig.displayLabel}
            </label>
          )}
  
          {fieldConfig?.em_label !== undefined &&
            <em className="smallLabel">{fieldConfig?.em_label}</em>      
            }
          <span className={fieldConfig?.icon ? "withInIcon" : "mr-12"}>
            {fieldConfig?.icon && (
              <i className="material-symbols-rounded grey mt-s static">
                {fieldConfig?.icon}
              </i>
            )}
            <input
              id={fieldConfig.id}
              type={fieldConfig.config.dataType}
              // min={fieldConfig.config.dataType==="number"?fieldConfig.min:""}
              name={fieldConfig.id}
              value={fieldConfig?.value}
              required={fieldConfig.validation.required}
              placeholder={
                fieldConfig?.placeholder
                  ? fieldConfig.placeholder
                  : fieldConfig?.options?.[0]?.displayValue
              }
              minLength={fieldConfig.validation.minLength}
              onChange={props.changed}
              maxLength={fieldConfig.validation.maxLength}
              // disabled={fieldConfig?.options?.[0]?.value ? "disabled" : ""}
            />
          </span>
        </div>
      );

      break;
    case "textarea":
      htmlInputType = (
        <>
          <label htmlFor={fieldConfig.id}>{fieldConfig.displayLabel}</label>
          <textarea
            value={fieldConfig.value}
            required={fieldConfig.validation.required}
            minLength={fieldConfig.validation.minLength}
            onChange={props.changed}
            maxLength={fieldConfig.validation.maxLength}
          />
        </>
      );
      break;
    case "select":
      htmlInputType = (
        <div
          className={
            fieldConfig?.divCustomClass !== undefined &&
            fieldConfig?.divCustomClass != ""
              ? fieldConfig?.divCustomClass
              : ""
          }
          style={{ width: "300px" }}
        >
          {fieldConfig.displayLabel && (
            <label
              htmlFor={fieldConfig.id}
              style={{ fontWeight: "bold", fontSize: "16px" }}
            >
              {fieldConfig.displayLabel}
            </label>
          )}
          <select
            value={fieldConfig.value}
            required={fieldConfig.validation.required}
            onChange={props.changed}
            id={fieldConfig.id}
            name={fieldConfig.id}
          >
            <option>{fieldConfig.placeholder}</option>
            {fieldConfig.options.map((option) => (
              <option key={option.id} value={option.value}>
                {option.displayValue}
              </option>
            ))}
          </select>
        </div>
      );
      break;
    case "radio":
      let radio_classes = "";
      if (!fieldConfig?.disableFieldGroup) {
        radio_classes = "fieldGroup";
      }
      if (
        fieldConfig?.additionalClass !== undefined &&
        fieldConfig?.additionalClass != ""
      ) {
        radio_classes += " " + fieldConfig?.additionalClass;
      }
      let radioGroupClass = "xTypeBox";

      if (
        fieldConfig?.customRadioClass !== undefined &&
        fieldConfig?.customRadioClass != ""
      ) {
        radioGroupClass += " " + fieldConfig.customRadioClass;
      }
      htmlInputType = (
        <div
          className={radio_classes}
          id={fieldConfig.id}
          style={
            fieldConfig.hidden
              ? {
                  display: isChecked?.[fieldConfig.id] ? "block" : "none",
                  width: "60%",
                }
              : { display: "block" }
          }
        >
          <label
            htmlFor={fieldConfig.id}
            style={{ fontWeight: "bold", fontSize: "16px" }}
          >
            {fieldConfig.displayLabel}
          </label>
          <div className={fieldConfig.id.split("_")[1]==process.env.REACT_APP_MOBILE_CHARGING_SERVICE_ID?"cnr":radioGroupClass}>
            {fieldConfig.options.map((option, i) => ( 
                fieldConfig?.object_key == "addon" ? (
                    
                    ((fieldConfig.value == 1 && option.value == 1) || (fieldConfig.value == 2 && option.value == 2) || (fieldConfig.value == 0 || fieldConfig.value == "" || fieldConfig.value === undefined)) &&
              <React.Fragment key={option.value}>
                {props.extraInfo.formData?.package_category_type!=recovery_insurance_category_type?(<><span
                  style={{
                    position: "relative",
                  }}
                  className={
                    fieldConfig.options.length === 1
                      ? "active single"
                      : option.value === fieldConfig.value &&
                        fieldConfig.options.length > 1
                      ? "active"
                      : ""
                  }
                >
                  <input
                    style={{
                      display: "inline-block",
                      //padding: "16px 16px 14px 16px",
                      //border: "1px solid #e0e0e0",
                      //borderRadius: "8px",
                      //appearance: "auto",
                      outline: "none",
                      userSelect: "text",
                      minWidth: "35px",
                      //width: "100%",
                      height: "100%",
                      position: "absolute",
                      left: "0",
                      top: "0",
                      cursor: "pointer",
                      opacity: 0,
                    }}
                    // className="input__radio"
                    id={option.id}
                    type={fieldConfig.config.dataType}
                    name={fieldConfig.name}
                    value={option.value}
                    // checked={
                    //   fieldConfig?.options?.length ===1
                    //     ? true
                    //     : option.value === fieldConfig.value
                    // }
                    checked={option.value === fieldConfig.value}
                    onChange={props.changed}
                    required={fieldConfig.validation.required}
                  />
                  {option.displayValue}
                </span></>):""}
              </React.Fragment>) : (
                <React.Fragment key={option.value}>
                  <span
                    style={{
                      position: "relative",
                    }}
                    className={
                      fieldConfig.options.length === 1
                        ? "active single"
                        : option.value === fieldConfig.value &&
                          fieldConfig.options.length > 1
                        ? "active"
                        : ""
                    }
                  >
                    <input
                      style={{
                        display: "inline-block",
                        //padding: "16px 16px 14px 16px",
                        //border: "1px solid #e0e0e0",
                        //borderRadius: "8px",
                        //appearance: "auto",
                        outline: "none",
                        userSelect: "text",
                        minWidth: "35px",
                        //width: "100%",
                        height: "100%",
                        position: "absolute",
                        left: "0",
                        top: "0",
                        cursor: "pointer",
                        opacity: 0,
                      }}
                      // className="input__radio"
                      id={option.id}
                      type={fieldConfig.config.dataType}
                      name={fieldConfig.name}
                      value={option.value}
                      // checked={
                      //   fieldConfig?.options?.length ===1
                      //     ? true
                      //     : option.value === fieldConfig.value
                      // }
                      checked={option.value === fieldConfig.value}
                      onChange={props.changed}
                      required={fieldConfig.validation.required}
                    />
                    {option.displayValue}
                  </span>
                </React.Fragment>
              )
            ))}
            {fieldConfig.id.split("_")[1]==process.env.REACT_APP_MOBILE_CHARGING_SERVICE_ID&&(<>
                                        <div>
                                          <label>Charging free upto</label>
                                          <span class="withInIcon" style={{marginTop:"5px",width:"170px"}}>
                                    <i class="material-symbols-rounded grey mt-s static">percent</i>
                                    <input id ="package_free_charge_upto" type="number" name="package_free_charge_upto" value={fieldConfig?.value} onChange={props.changed} placeholder="Enter number" />
                                </span>
                                {props?.error&&props?.error['package_free_charge_upto']&&<Error error={props?.error['package_free_charge_upto']}/>}
                                </div>
                                  </>)}
            {props?.extraInfo?.formData?.package_category_type!=recovery_insurance_category_type&&fieldConfig?.object_key == "addon" &&
                    fieldConfig.value == "1" ?
                (<span className="">
                    <input className="max_service_allowed" type="text" placeholder="Enter number" 
                        name="max_service_allowed" 
                        style={{
                        paddingTop: 0,
                        paddingBottom: 0,
                        border: "none",
                        width: "89px",
                        paddingRight: 0,
                        paddingLeft: 0,
                        borderRadius: 0
                           }}
                        value={fieldConfig?.max_service_allowed !== undefined ? fieldConfig?.max_service_allowed : ""}   
                        onChange={(e) => changeAddonValues(e,fieldConfig,props.index)} />
                    <i style={{fontSize: "13px"}}>/</i>
                    <input className="service_charge" name="service_charge" type="text" placeholder="Enter custom price if no free" 
                        name="service_charge" 
                        style={{
                        paddingTop: 0,
                        paddingBottom: 0,
                        border: "none",
                        minWidth: "220px",
                        paddingLeft: "9px",
                        borderRadius: 0
                        }}
                        value={fieldConfig?.service_charge !== undefined ? fieldConfig?.service_charge : ""}  
                        onChange={(e) => changeAddonValues(e,fieldConfig,props.index)}
                        />
                    <a className="ml-16" onClick={props.changed}>Cancel</a>
                </span>) : props?.extraInfo?.formData?.package_category_type!=recovery_insurance_category_type&&fieldConfig?.object_key == "addon" &&
                    fieldConfig.value == "2" ? (
                        <span className="">
                        <input className="service_charge" type="text" placeholder="Enter price" 
                            name="service_charge" 
                            style={{
                            paddingTop: 0,
                            paddingBottom: 0,
                            border: "none",
                            width: "150px",
                            paddingRight: 0,
                            paddingLeft: 0,
                            borderRadius: 0
                           }}
                           value={fieldConfig?.service_charge !== undefined ? fieldConfig?.service_charge : ""}  
                            onChange={(e) => changeAddonValues(e,fieldConfig,props.index)}
                            />
                            <a className="ml-16" onClick={props.changed}>Cancel</a>
                        </span>
                    )  : ""     
            }
          </div>
        </div>
      );
      break;
    case "checkBox":
      htmlInputType = (
        <div
          className={
            fieldConfig.customClass !== undefined &&
            fieldConfig.customClass != ""
              ? fieldConfig.customClass
              : ""
          }
        >
          <input
            type={fieldConfig.config.dataType}
            value={fieldConfig.value}
            required={fieldConfig.validation.required}
            onChange={props.changed}
            id={fieldConfig.id}
            name={fieldConfig.name}
          />
          <label htmlFor={fieldConfig.id}>{fieldConfig.displayLabel}</label>
          <br />
        </div>
      );
      break;
    case "label":
      if (
        fieldConfig?.divCustomClass !== undefined &&
        fieldConfig?.divCustomClass != ""
      ) {
        htmlInputType = (
          <div className={fieldConfig?.divCustomClass}>
            <label
              htmlFor={fieldConfig.id}
              style={{ fontWeight: "bold", fontSize: "16px" }}
            >
              {fieldConfig.displayLabel}
            </label>
          </div>
        );
      } else {
        htmlInputType = (
          <>
            <label
              htmlFor={fieldConfig.id}
              style={{ fontWeight: "bold", fontSize: "16px" }}
            >
              {fieldConfig.displayLabel}
            </label>
          </>
        );
      }

      break;

    case "calculation":
      if (fieldConfig.data != "") {
        htmlInputType = (
          <div className="pacakgeDetails inlineFlex radius mt-16">
            <div className="dataTable">
              <div>
                <p>
                  <span>Total price</span>
                  <span>
                    ${fieldConfig.data.total_price}{" "}
                    <em>
                      (${fieldConfig.data.base_price} x{" "}
                      {fieldConfig.data.package_duration})
                    </em>
                  </span>
                </p>
                <p>
                  <span>Partner price</span>
                  <span>${fieldConfig.data.partner_price}</span>
                </p>
                <p>
                  <span>Total discount</span>
                  <span>${fieldConfig.data.discount}</span>
                </p>
              </div>
            </div>
          </div>
        );
      } else {
        htmlInputType = "";
      }

      break;

    default:
      htmlInputType = <div>Incorrect Input Type</div>;
  }

  return <>{htmlInputType}</>;
};

export default FieldElement;
