import React from "react";

const Email = (userEmail) => {
  return (
    <div className="userInfo w180">
      <div className="email">
        <span>Email</span>
        {userEmail == "" ? (
          <>
            <span>N/A</span>
          </>
        ) : (
          <>
            <span>{userEmail}</span>
          </>
        )}
      </div>
    </div>
  );
};

const Phone = (userPhoneNumber) => {
  return (
    <div className="userInfo w180">
      <div className="contactInfo">
        <span>Phone</span>
        {userPhoneNumber == "" || userPhoneNumber == 0 ? (
          <>
            <span>N/A</span>
          </>
        ) : (
          <>
            <span>{userPhoneNumber}</span>
          </>
        )}
      </div>
    </div>
  );
};

export const Text = (type, value) => {
  switch (type) {
    case "Email":
      return Email(value);
    case "Phone":
      return Phone(value);
  }
};
