import React from "react";
import MainContainer from "../../UI/MainContainer";
import Header from "../../Layouts/Header/Header";
import SubMainContainer from "../../UI/SubMainContainer";
import SearchBar from "../../UI/SearchBar/SearchBar";
import SideBar from "../../Layouts/SideBar/SideBar";
import useAuth from "../../../hooks/useAuth";
import DataNotFound from "../../UI/DataNotFound";
// import Navigation from "../Setting/Navigation";
// import { Link } from "react-router-dom";
// import AddEmployee from "../../Settings/Employee/AddEmployee";
// import EmployeeData from "../../Settings/Employee/EmployeeData";
// import EditEmployee from "../../Settings/Employee/EditEmployee";
import AccountsData from "../../Accounts/AccountsData";
import PartnerAccountsInfo from "../../Accounts/PartnerAccountsInfo";
import AccountsDetails from "../../Accounts/AccountsDetails";
import { useState } from "react";
import { pageTitles } from "../../../configuration/GlobalConfig";
import NoPriviliges from "../../UI/NoPriviliges";

function Accounts(props) {
  document.title = pageTitles.ACCOUNTS;
  const { auth } = useAuth();
  const [searchValue, setSearchValue] = useState("");
  const [partnerDetails, setPartnerDetails] = useState("");
  const [pageNumber, setPageNumber] = useState(0);
  return (
    <>
      {/* setData={setPartnerDetails}
                  setPageNumber={setPageNumber} */}
      {/*<div id="portal-root"></div>*/}
      <MainContainer>
        <Header />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer accountsDashboard">
              <h2>Accounts</h2>
              {auth.priviliges.includes("read_accounts")?<>
              <AccountsDetails />
            

              <PartnerAccountsInfo
                searchValue={searchValue}
                setSearchValue={setSearchValue}
                pageNumber={pageNumber}
                setPageNumber={setPageNumber}
                partnerDetails={partnerDetails}
                setPartnerDetails={setPartnerDetails}
              /></>:  <NoPriviliges message="no priviliges"/>}
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
}

export default Accounts;
