import { useState } from "react";
import SideBar from "../../Layouts/SideBar/SideBar";
import MainContainer from "../../UI/MainContainer";
import SubMainContainer from "../../UI/SubMainContainer";
import Headers from "../../Layouts/Header/Header";
import { Link } from "react-router-dom";
import CustomerDetails from "../../Customer/CustomerDetails";
import AttendantProfile from "../../Attendants/AttendantProfile";

const AttendantsDetails = () => {
  return (
    <>
      <MainContainer>
        <Headers />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <h2>
                <Link to="/attendants">
                  <span className="material-symbols-rounded mt-l black">
                    arrow_back
                  </span>
                </Link>
                Attendant details
              </h2>
              <div className="subContent">
                <AttendantProfile />
              </div>
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default AttendantsDetails;
