import { useState } from "react";
import { useRef } from "react";

import Headers from "../../Layouts/Header/Header";
import SubMainContainer from "../../UI/SubMainContainer";
import MainContainer from "../../UI/MainContainer";
import SideBar from "../../Layouts/SideBar/SideBar";
import SearchBar from "../../UI/SearchBar/SearchBar";
import Button from "../../UI/Button";

import AttendantsInfo from "../../Attendants/AttendentsInfo";
import AttendantsDetails from "../../Attendants/AttendentsDetails";
import { pageTitles } from "../../../configuration/GlobalConfig";
import useAuth from "../../../hooks/useAuth";
import DataNotFound from "../../UI/DataNotFound";
import Spinner from "../../UI/Spinner";
import NoPriviliges from "../../UI/NoPriviliges";

const Attendants = () => {
  document.title = pageTitles.ATTENDANT;
  const [searchValue, setSearchValue] = useState("");
  const [success, setSuccess] = useState(false);
  const [attendentInfo, setAttendentInfo] = useState("");
  const [pageNumber, setPageNumber] = useState(1);
  const inputElement = useRef();
  const [error, setError] = useState({
    errType: "",
    errValue: "",
  });
  const { auth } = useAuth();
  return (
    <>
      <MainContainer>
        <Headers errData={error.errType} errValue={error.errValue} />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <h2>Attendants</h2>
              {auth.priviliges.length > "0" ? auth.priviliges.includes("read_attendant") ?
                <div className="subContent AttendantDashBoard">
                  <AttendantsDetails success={success} setSuccess={setSuccess} />
                  <div className="searchPanel mb-24">
                    <SearchBar
                      setSearchValue={setSearchValue}
                      searchValue={searchValue}
                      placeholder={"Search any attendant by name"}
                      inputElement={inputElement}
                      setData={setAttendentInfo}
                      attendentInfo={attendentInfo}
                      pageNumber={pageNumber}
                      setPageNumber={setPageNumber}
                    />
                    {auth.priviliges.includes("write_attendant")&&
                    <Button
                      value="Add new driver"
                      btn_link={"/createNewAttendant"}
                    />}
                  </div>

                  <AttendantsInfo
                    setError={setError}
                    searchValue={searchValue}
                    setSearchValue={setSearchValue}
                    inputElement={inputElement}
                    success={success}
                    setSuccess={setSuccess}
                    setAttendentInfo={setAttendentInfo}
                    attendentInfo={attendentInfo}
                    pageNumber={pageNumber}
                    setPageNumber={setPageNumber}
                  />
                </div> : <NoPriviliges message="no privilliges" /> : <Spinner />}
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default Attendants;
