import React from "react";
import MainContainer from "../../UI/MainContainer";
import Header from "../../Layouts/Header/Header";
import SubMainContainer from "../../UI/SubMainContainer";
import SideBar from "../../Layouts/SideBar/SideBar";
import { Link, useNavigate } from "react-router-dom";
import CreateNewAttendant from "../../Attendants/CreateAttendant/CreateNewAttendant";
export default function CreateAttendant() {
  const navigate = useNavigate();
  const goBack = () => {
    //console.log("here")
    navigate(-1);
  };
  return (
    <>
      <MainContainer>
        <Header />
        <SubMainContainer>
          <SideBar />
          <SubMainContainer SubMainContainerCustomClass="rightCol">
            <div className="contentContainer">
              <h2>
                <Link to="/attendants">
                  <span className="material-symbols-rounded mt-l black">
                    arrow_back
                  </span>
                </Link>
                Add new attendant
              </h2>
              <CreateNewAttendant />
            </div>
          </SubMainContainer>
        </SubMainContainer>
      </MainContainer>
    </>
  );
}
