import React from 'react';
import { useState } from 'react';
import MainContainer from '../../UI/MainContainer';
import SubMainContainer from '../../UI/SubMainContainer';
import Header from '../../Layouts/Header/Header';
import SideBar from '../../Layouts/SideBar/SideBar';
import BookingCalendar from '../../BookingSlots/BookingCalendar';
import { pageTitles } from '../../../configuration/GlobalConfig';
import NoPriviliges from '../../UI/NoPriviliges';
import useAuth from '../../../hooks/useAuth';
import Spinner from '../../UI/Spinner';
//import UploadSlots from '../../BookingSlots/UploadSlots';
export default function BookingSlots() {
    document.title = pageTitles.SLOTS;
    const [error, setError] = useState({
        errType: "",
        errValue: "",
    });
    const { auth } = useAuth();
    const [uploadSlotsPopup, setuploadSlotsPopUP] = useState(false);
    const onBackdropClick = () => {
        document.body.classList.remove('hidden');
        setuploadSlotsPopUP(false);
    }
    return (
        <>
            <MainContainer>
                <Header errData={error.errType} errValue={error.errValue} />
                <SubMainContainer>
                    <SideBar />
                    <div className="rightCol">
                        <div className="contentContainer">
                            <div class="mHeadingWrap">
                                <h2>Booking slots</h2>
                                {auth.priviliges.includes("write_booking_slots") && <a class="btn prim open_model" data-target="uploadSlotsP" onClick={() => { setuploadSlotsPopUP(true) }}><i class="material-symbols-rounded mt-m grey">upload_file</i>Upload manually</a>}
                            </div>
                            {auth.priviliges.length > "0" ?auth.priviliges.includes("read_booking_slots") ?
                                <BookingCalendar uploadSlotsPopup={uploadSlotsPopup} setuploadSlotsPopUP={setuploadSlotsPopUP} onBackdropClick={onBackdropClick} />:<NoPriviliges/>:<Spinner/>}
                        </div>
                    </div>
                </SubMainContainer>

            </MainContainer>
        </>
    )
}
