import { useState } from "react";
import SideBar from "../../Layouts/SideBar/SideBar";
import MainContainer from "../../UI/MainContainer";
import SubMainContainer from "../../UI/SubMainContainer";
import Headers from "../../Layouts/Header/Header";
import Button from "../../UI/Button";
import BrandInfo from "../../Brand/BrandInfo";

import { pageTitles } from "../../../configuration/GlobalConfig";

const Customer = () => {
  document.title = pageTitles.BRAND;
  const [searchValue, setSearchValue] = useState("");
  const [error, setError] = useState({
    errType: "",
    errValue: "",
  });

  return (
    <>
      <MainContainer>
        <Headers errData={error.errType} errValue={error.errValue} />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <h2>Brands</h2>
              <div className="searchPanel">
                <Button
                  value="Create new Brand"
                  btn_link={"/brand/createNewBrand"}
                />
              </div>

              <div className="subContent pt-24">
                <BrandInfo
                  setError={setError}
                  searchValue={searchValue}
                  setSearchValue={setSearchValue}
                />
              </div>
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default Customer;
