import { useState, useRef } from "react";
import { Link } from "react-router-dom";
import SideBar from "../../Layouts/SideBar/SideBar";
import MainContainer from "../../UI/MainContainer";
import SubMainContainer from "../../UI/SubMainContainer";
import Headers from "../../Layouts/Header/Header";
import BrandModelVariantDetails from "../../Brand/BrandModelVariantDetails";

const BrandModelVariantList = () => {
  const [searchValue, setSearchValue] = useState("");
  const inputElement = useRef();
  const [error, setError] = useState({
    errType: "",
    errValue: "",
  });

  return (
    <>
      <MainContainer>
        <Headers errData={error.errType} errValue={error.errValue} />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <h2>
                <Link to="/brand">
                  <span className="material-symbols-rounded mt-l black">
                    arrow_back
                  </span>
                </Link>
                Variants
              </h2>

              <div className="subContent pt-24">
                <BrandModelVariantDetails
                  setError={setError}
                  searchValue={searchValue}
                  setSearchValue={setSearchValue}
                  inputElement={inputElement}
                />
              </div>
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default BrandModelVariantList;
