import React from 'react'
import { useState } from 'react'
import { useNavigate } from 'react-router-dom'
import MainContainer from '../../UI/MainContainer'
import SubMainContainer from '../../UI/SubMainContainer'
import Header from '../../Layouts/Header/Header'
import SideBar from '../../Layouts/SideBar/SideBar'
import AddDeploymentCentre from '../../ChargingCenters/AddDeploymentCentre'
export default function AddNewChargingCentre() {
    const navigate = useNavigate();
    const [error, setError] = useState({
        errType: "",
        errValue: "",
    });
    return (
        <>
            <MainContainer>
                <Header errData={error.errType} errValue={error.errValue} />
                <SubMainContainer>
                    <SideBar />
                    <div className="rightCol">
                        <div className="contentContainer">
                            <h2>
                                <a onClick={() => { navigate(-1) }} style={{ cursor: "pointer" }}>
                                    <span class="material-symbols-rounded mt-l black">arrow_back</span>
                                </a>Add charging station
                            </h2>
                            <AddDeploymentCentre />
                        </div>
                    </div>
                </SubMainContainer>
            </MainContainer>

        </>
    )
}
