import React from 'react'
import { useState } from 'react'
import DeploymentCentre from '../../ChargingCenters/DeploymentCenter'
import MainContainer from '../../UI/MainContainer'
import SubMainContainer from '../../UI/SubMainContainer'
import Header from '../../Layouts/Header/Header'
import SideBar from '../../Layouts/SideBar/SideBar'
import DataNotFound from '../../UI/DataNotFound'
import useAuth from '../../../hooks/useAuth'
import NoPriviliges from '../../UI/NoPriviliges'
export default function ChargingCenters() {
    const { auth } = useAuth();
    const [error, setError] = useState({
        errType: "",
        errValue: "",
    });
    return (
        <>
            <MainContainer>
                <Header errData={error.errType} errValue={error.errValue} />
                <SubMainContainer>
                    <SideBar />
                    <div className="rightCol">
                        <div className="contentContainer">
                            <h2>Charging centers
                            </h2>
                            {auth.priviliges.includes("read_charging_center") ?  <DeploymentCentre />: <NoPriviliges message="no priviliges"/>}
                          
                        </div>
                    </div>
                </SubMainContainer>
            </MainContainer>
        </>
    )
}
