import React from 'react'
import { useState } from 'react'
import SubMainContainer from '../../UI/SubMainContainer'
import MainContainer from '../../UI/MainContainer'
import Header from '../../Layouts/Header/Header'
import SideBar from '../../Layouts/SideBar/SideBar'
import { useNavigate, Link } from 'react-router-dom'
import DeploymentCenterDetails from '../../ChargingCenters/DeploymentCenterDetails'
export default function ChargingCentersDetails() {
    const navigate = useNavigate();
    const [error, setError] = useState({
        errType: "",
        errValue: "",
    });
    return (
        <>

            <MainContainer>
                <Header errData={error.errType} errValue={error.errValue} />
                <SubMainContainer>
                    <SideBar />

                    <div className="rightCol">
                        <div className="contentContainer">
                            <h2>
                                <Link to="/charging_centers">
                                    <span class="material-symbols-rounded mt-l black">arrow_back</span>
                                </Link>Charging station details
                            </h2>
                            <DeploymentCenterDetails />
                        </div>
                    </div>
                </SubMainContainer>



            </MainContainer>
        </>
    )
}
