import { useState } from "react";
import { useRef } from "react";
import SideBar from "../../../Layouts/SideBar/SideBar";
import MainContainer from "../../../UI/MainContainer";
import SubMainContainer from "../../../UI/SubMainContainer";
import { pageTitles } from "../../../../configuration/GlobalConfig";
import SearchBar from "../../../UI/SearchBar/SearchBar";
import CustomerInfo from "../../../Customer/CustomerInfo";
import Button from "../../../UI/Button";
import PatnerInfo from "../../../Customer/Partner/PartnerInfo";
import CorporateInfo from "../../../Customer/Corporate/CorporateInfo";
import Headers from "../../../Layouts/Header/Header";
import useAuth from "../../../../hooks/useAuth";
import Spinner from "../../../UI/Spinner";
import DataNotFound from "../../../UI/DataNotFound";
import NoPriviliges from "../../../UI/NoPriviliges";

const Corporate = () => {
  document.title = pageTitles.CORPORATE;
  const [searchValue, setSearchValue] = useState("");
  const { auth } = useAuth();
  const inputElement = useRef();
  const [pageNumber, setPageNumber] = useState(1);
  const [corporateDetails, setCorporateDetails] = useState("");
  const [error, setError] = useState({
    errType: "",
    errValue: "",
  });

  return (
    <>
      <MainContainer>
        <Headers errData={error.errType} errValue={error.errValue} />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <h2>Corporate customers</h2>{
                auth.priviliges.length > "0" ? auth.priviliges.includes("read_partners") ?
                  <>
                   <div className="searchPanel">
                <SearchBar
                  setSearchValue={setSearchValue}
                  searchValue={searchValue}
                  placeholder={"Search any partner by name, phone"}
                  inputElement={inputElement}
                  setData={setCorporateDetails}
                  corporateDetails={corporateDetails}
                  pageNumber={pageNumber}
                  setPageNumber={setPageNumber}
                      />
                      {
                        auth.priviliges.includes("write_partners") &&
                      
                        <Button
                          value="Add new customer"
                          btn_link={"/customers/CreateNewCorporate"}
                        />}
              </div>

              <div className="subContent pt-24">
                <CorporateInfo
                  setError={setError}
                  searchValue={searchValue}
                  setSearchValue={setSearchValue}
                  inputElement={inputElement}
                  setCorporateDetails={setCorporateDetails}
                  corporateDetails={corporateDetails}
                  pageNumber={pageNumber}
                  setPageNumber={setPageNumber}
                />
              </div>
                  </>
                :
                 <NoPriviliges message="no privilliges" />:<Spinner/>
              }
             
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default Corporate;
