import { useState, useRef } from "react";
import SideBar from "../../Layouts/SideBar/SideBar";
import MainContainer from "../../UI/MainContainer";
import SubMainContainer from "../../UI/SubMainContainer";
import Headers from "../../Layouts/Header/Header";
import SearchBar from "../../UI/SearchBar/SearchBar";
import CustomerInfo from "../../Customer/CustomerInfo";
import Button from "../../UI/Button";
import useAuth from "../../../hooks/useAuth";
import Spinner from "../../UI/Spinner";

import { pageTitles } from "../../../configuration/GlobalConfig";
import DataNotFound from "../../UI/DataNotFound";
import NoPriviliges from "../../UI/NoPriviliges";

const Customer = () => {
  document.title = pageTitles.CUSTOMERS;
  const [searchValue, setSearchValue] = useState("");
  const [pageNumber, setPageNumber] = useState(1);
  const [users, setUsers] = useState("");
  const inputElement = useRef();
  const {auth, setAuth} = useAuth();
  const [error, setError] = useState({
    errType: "",
    errValue: "",
  });

  return (
    <>
     
        <MainContainer>
          <Headers errData={error.errType} errValue={error.errValue} />
          <SubMainContainer>
            <SideBar />
            <div className="rightCol">
              <div className="contentContainer">
              <h2>Customers</h2>
              
                {
                 auth.priviliges.length>"0"? auth.priviliges.includes("read_customers") ?
                    <>
                     <div className="searchPanel">
                  <SearchBar
                    setSearchValue={setSearchValue}
                    searchValue={searchValue}
                    placeholder={"Search any customer by firstname, phone"}
                    inputElement={inputElement}
                    customStyle={{ width: "370px" }}
                    pageNumber={pageNumber}
                    setPageNumber={setPageNumber}
                    users={users}
                    setData={setUsers}
                      />
                      {auth.priviliges.includes("write_credits") &&
                        <Button
                          value="Add new customer"
                          btn_link={"/customers/createNewCustomer"}
                        />}
                </div>

                <div className="subContent pt-24">
                  <CustomerInfo
                    setError={setError}
                    searchValue={searchValue}
                    setSearchValue={setSearchValue}
                    inputElement={inputElement}
                    pageNumber={pageNumber}
                    setPageNumber={setPageNumber}
                    users={users}
                    setUsers={setUsers}
                  />
                </div>
                    </>
                  : <NoPriviliges message="no priviliges"/>:<Spinner/>
                }
               
              </div>
            </div>
          </SubMainContainer>
        </MainContainer>
    </>
  );
};

export default Customer;
