import { useState } from "react";
import { useRef } from "react";
import Headers from "../../../Layouts/Header/Header";
import SubMainContainer from "../../../UI/SubMainContainer";
import MainContainer from "../../../UI/MainContainer";
import SideBar from "../../../Layouts/SideBar/SideBar";
import SearchBar from "../../../UI/SearchBar/SearchBar";
import Button from "../../../UI/Button";
import PartnerInfo from "../../../Customer/Partner/PartnerInfo";
import { pageTitles } from "../../../../configuration/GlobalConfig";
import DataNotFound from "../../../UI/DataNotFound";
import Spinner from "../../../UI/Spinner";
import useAuth from "../../../../hooks/useAuth";
import NoPriviliges from "../../../UI/NoPriviliges";

const Partner = () => {
  document.title = pageTitles.PARTNERS;
  const { auth, setAuth } = useAuth();
  const [searchValue, setSearchValue] = useState("");
  const [partnerDetails, setPartnerDetails] = useState("");
  const [pageNumber, setPageNumber] = useState(1);
  const inputElement = useRef();
  const [error, setError] = useState({
    errType: "",
    errValue: "",
  });

  return (
    <>
      <MainContainer>
        <Headers errData={error.errType} errValue={error.errValue} />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <h2>Partner customers</h2>
              {
                auth.priviliges.length > "0" ? auth.priviliges.includes("read_partners") ?
                  <>
                   <div className="searchPanel">
                <SearchBar
                  setSearchValue={setSearchValue}
                  searchValue={searchValue}
                  placeholder={"Search any partner by name, phone"}
                  inputElement={inputElement}
                  setData={setPartnerDetails}
                  setPageNumber={setPageNumber}
                      />
                      {auth.priviliges.includes("write_partners") &&
                      
                        <Button
                          value="Add new customer"
                          btn_link={"/customers/createNewPartner"}
                        />}
              </div>

              <div className="subContent pt-24">
                <PartnerInfo
                  setError={setError}
                  searchValue={searchValue}
                  setSearchValue={setSearchValue}
                  inputElement={inputElement}
                  partnerDetails={partnerDetails}
                  setPartnerDetails={setPartnerDetails}
                  pageNumber={pageNumber}
                  setPageNumber={setPageNumber}
                />
              </div>
                  </>
                : <NoPriviliges message="no privilliges" />:<Spinner/>

              }
             
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default Partner;
