import { useState } from "react";
import { useRef } from "react";
import Headers from "../../../Layouts/Header/Header";
import SubMainContainer from "../../../UI/SubMainContainer";
import MainContainer from "../../../UI/MainContainer";
import SideBar from "../../../Layouts/SideBar/SideBar";
import SearchBar from "../../../UI/SearchBar/SearchBar";
import Button from "../../../UI/Button";
import PartnerInfo from "../../../Customer/Partner/PartnerInfo";
import { pageTitles } from "../../../../configuration/GlobalConfig";
import CustomerPartnerDetails from "../../../Customer/Partner/CustomerPartnerDetails";
import { Link } from "react-router-dom";
const PartnerDetails = () => {
  document.title = pageTitles.PARTNERS;
  const [searchValue, setSearchValue] = useState("");
  const inputElement = useRef();
  const [error, setError] = useState({
    errType: "",
    errValue: "",
  });

  return (
    <>
      <MainContainer>
        <Headers errData={error.errType} errValue={error.errValue} />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <h2>
                <Link to="/customers/partner">
                  <span class="material-symbols-rounded mt-l black">
                    arrow_back
                  </span>
                </Link>
                Partner details
              </h2>
              {/* <div className="searchPanel">
                <SearchBar
                  setSearchValue={setSearchValue}
                  searchValue={searchValue}
                  placeholder={"Search any partner by name"}
                  inputElement={inputElement}
                />
              </div> */}

              <div className="subContent">
                <CustomerPartnerDetails
                  setError={setError}
                  searchValue={searchValue}
                  setSearchValue={setSearchValue}
                  inputElement={inputElement}
                />
              </div>
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default PartnerDetails;
