import { useState, useEffect, useRef } from "react";
import { useNavigate, useLocation } from "react-router-dom";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import FilterData from "../../../utils/FilterData";

const UsersInfo = () => {
  const [users, setUsers] = useState();
  const [searchItem, setSearchItem] = useState([]);
  const navigate = useNavigate();
  const location = useLocation();
  const axiosPrivate = useAxiosIntercept();
  const effectRun = useRef(false);

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getUsers = async () => {
      try {
        const response = await axiosPrivate.get(
          process.env.REACT_APP_USER_INFO_URL,
          {
            signal: controller.signal,
          }
        );
        isMounted && setUsers(response?.data?.response?.data?.user_info);
      } catch (err) {
        console.error(err);
        navigate("/", { state: { from: location }, replace: true });
      }
    };

    // Check if useEffect has run the first time
    if (!effectRun.current) {
      getUsers();
    }

    return () => {
      isMounted = false;
      controller.abort();
      effectRun.current = true; // update the value of effectRun to true
    };
  }, []);

  return (
    <article>
      <input
        type="text"
        placeholder="Search.."
        value={searchItem}
        onChange={(e) => setSearchItem(e.target.value)}
      />
      <h2>Users List</h2>
      {users?.[0] ? (
        <ul>
          <FilterData
            data={users}
            searchValue={searchItem}
            searchKey="firstname"
          />
        </ul>
      ) : (
        <p>No users to display</p>
      )}
    </article>
  );
};

export default UsersInfo;
