import { useState } from "react";
import SideBar from "../../Layouts/SideBar/SideBar";
import MainContainer from "../../UI/MainContainer";
import SubMainContainer from "../../UI/SubMainContainer";
import Headers from "../../Layouts/Header/Header";
import SearchBar from "../../UI/SearchBar/SearchBar";
import CustomerInfo from "../../Customer/CustomerInfo";
import DriversInfo from "../../Drivers/DriversInfo";
import Button from "../../UI/Button";

const Drivers = () => {
  const [searchValue, setSearchValue] = useState("");
  const [keyValue, setKeyValue] = useState("");
  return (
    <>
      <MainContainer>
        <Headers />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <h2>Drivers</h2>
              <div className="searchPanel">
              <SearchBar
                setSearchValue={setSearchValue}
                searchValue={searchValue}
                placeholder={"Search any driver by name, email, phone"}
              />
              <Button value={"Create New Driver"}/>
              </div>
              <div className="subContent pt-24">
                <DriversInfo
                  searchValue={searchValue}
                  setSearchValue={setSearchValue}
                />
              </div>
            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default Drivers;
