import React,{useState} from 'react'
import Headers from '../../Layouts/Header/Header'
import SubMainContainer from '../../UI/SubMainContainer'
import MainContainer from '../../UI/MainContainer'
import SideBar from '../../Layouts/SideBar/SideBar'
import useAuth from '../../../hooks/useAuth'
import JobPlannerdisplay from '../../JobPlanner/JobPlannerdisplay'
import JobPlannerDisplayData from '../../JobPlanner/JobPlanerDisplayData'
import NoPriviliges from "../../UI/NoPriviliges";
import Spinner from '../../UI/Spinner'


const JobPlanner = () => {
    const { auth } = useAuth();
    const [showPopUp, setShowPopUp] = useState({
        upLoadAttendance: false,
        saveAttendance: false,
        editAttendance:false
    });
    const [attendanceInfo,setAttendanceInfo]=useState({})
    const openPopUp = (e) => {
        setShowPopUp({[e.target.id]: true})
    }
    
    return (
        <MainContainer>
            <Headers />
            <SubMainContainer>
                <SideBar />
                <div className="rightCol">
                    <div className="contentContainer">
                        <div className="mHeadingWrap">
                            <h2>Job planner</h2>
                            {
                               auth.priviliges.includes("write_job_planner") &&
                            
                            <div class="actionLinks">
                                <a onClick={ openPopUp} id="upLoadAttenance" href="javascript:void(0);" class="btn prim open_model mr-12" data-target="uploadSlotsP">
                                    <i class="material-symbols-rounded mt-m grey">upload_file</i>
                                    Upload file
                                </a>
                                <a onClick={ openPopUp} id="addNewPlan" href="javascript:void(0);" class="btn prim open_model" data-target="addJobPlannerP">
                                    <i class="material-symbols-rounded mt-m grey">person_add</i>
                                    Add new plan
                                </a>
                            </div>}
                        </div>


                        {
                             // auth.priviliges.length>"0"? auth.priviliges.includes("read_job_planner") ?
                            <>


                                <JobPlannerDisplayData showPopUp={showPopUp} setShowPopUp={setShowPopUp} attendanceInfo={attendanceInfo} setAttendanceInfo={setAttendanceInfo} />

                            </>
                              // : <NoPriviliges message="no priviliges"/>:<Spinner/>
                        }

                    </div>
                </div>
            </SubMainContainer>
        </MainContainer>
    )
}

export default JobPlanner