import React, { useState } from "react";
import Signin from "../../Auth/Signin";
import UserVerifyOtp from "../../Auth/UserVerifyOtp";
import useAuth from "../../../hooks/useAuth";
import Logo from "../../../assets/images/pup_logo.png";

export default function Login() {
  const [page, setPage] = useState(0);
  const { auth } = useAuth();

  return (
    <>
      <div className="pupLogin dForm">
        <div className="loginBlock">
          <div className="logo">
            <a href="index.php">
              <img src={Logo} alt="P.UP" />
            </a>
          </div>
          <div className="loginContent fieldGroup">
            {page === 0 ? (
              <Signin setPage={setPage} />
            ) : (
              <UserVerifyOtp setPage={setPage} />
            )}
          </div>
        </div>
      </div>
    </>
  );
}
