import React from "react";
import CreateCustomer from "../../Customer/CreateCustomer/CreateCustomer";
import MainContainer from "../../UI/MainContainer";
import Header from "../../Layouts/Header/Header";
import SubMainContainer from "../../UI/SubMainContainer";
import SideBar from "../../Layouts/SideBar/SideBar";
import { Link, useNavigate } from "react-router-dom";
import CreateNewPuppy from "../../Puppy/CreatePuppy/CreateNewPuppy";
import { useState } from "react";
export default function CreatePuppy() {
  const navigate = useNavigate();
  const [openAddPuppyForm, setOpenAddPuppyForm] = useState(true);
  const goBack = () => {
    //console.log("here")
    navigate(-1);
  };
  const [value, setValue] = useState();
  const onBackdropClick = () => {
    setOpenAddPuppyForm(false);
  };
  return (
    <>
      <MainContainer>
        <Header />
        <SubMainContainer>
          <SideBar />
          <SubMainContainer SubMainContainerCustomClass="rightCol">
            <div className="contentContainer">
              <h2>
                <Link to="" onClick={goBack}>
                  <span class="material-symbols-rounded mt-l black">
                    arrow_back
                  </span>
                </Link>
                Create new Puppy
              </h2>

              <CreateNewPuppy
                onBackdropClick={onBackdropClick}
                openAddPuppyForm={openAddPuppyForm}
              />
            </div>
          </SubMainContainer>
        </SubMainContainer>
      </MainContainer>
    </>
  );
}
