import { useState, useEffect } from "react";
import SideBar from "../../Layouts/SideBar/SideBar";
import MainContainer from "../../UI/MainContainer";
import SubMainContainer from "../../UI/SubMainContainer";
import Headers from "../../Layouts/Header/Header";
import SearchBar from "../../UI/SearchBar/SearchBar";
import PuppyInfo from "../../Puppy/PuppyInfo";
import Button from "../../UI/Button";
import { pageTitles } from "../../../configuration/GlobalConfig";
import useAuth from "../../../hooks/useAuth";
import Spinner from "../../UI/Spinner";
import DataNotFound from "../../UI/DataNotFound";
import NoPriviliges from "../../UI/NoPriviliges";

const Puppy = () => {
  const { auth } = useAuth();
  const [searchValue, setSearchValue] = useState("");
  const [puppyInfo, setPuppyInfo] = useState("");
  const [pageNumber, setPageNumber] = useState(1);
  const [keyValue, setKeyValue] = useState("");

  document.title = pageTitles.PUPPY;

  return (
    <>
      <MainContainer>
        <Headers />
        <SubMainContainer>
          <SideBar />
          <div className="rightCol">
            <div className="contentContainer">
              <h2>Puppy</h2>
              {auth.priviliges.length > "0" ? auth.priviliges.includes("read_puppy") ?

                <div className="subContent pt-24">
                  <PuppyInfo
                    searchValue={searchValue}
                    setSearchValue={setSearchValue}
                    puppyInfo={puppyInfo}
                    setPuppyInfo={setPuppyInfo}
                    pageNumber={pageNumber}
                    setPageNumber={setPageNumber}
                  />
                </div> :
                <NoPriviliges message="no privilliges" /> : <Spinner />}

            </div>
          </div>
        </SubMainContainer>
      </MainContainer>
    </>
  );
};

export default Puppy;
